/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.pdrDirectoryCache;
import au.com.nemmco.Pdr.Batcher.Transport.pdrSourceCache;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import au.com.nemmco.Util.FileLockWrapper;
import au.com.nemmco.Util.FtpFileInfo;
import au.com.nemmco.Util.JsonUtilities;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileCacheManager {
    private static Logger logger = LoggerFactory.getLogger(pdrFileCacheManager.class);
    private Map<String, pdrSourceCache> itsSourceCache = new ConcurrentHashMap<String, pdrSourceCache>();
    private String itsCacheStateFile = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_file_manager_cache", "file_manager_cache_state.txt");
    private FileLockWrapper itsLockFile;
    private Date itsLastPersisted;
    private int itsCacheStateFileWriteMins = Integer.parseInt(Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_file_manager_cache_write_mins", "5"));
    private static boolean hasInstance = false;

    private pdrFileCacheManager() {
        this.itsSourceCache = this.loadCacheFromFile();
        hasInstance = true;
    }

    public static pdrFileCacheManager getInstance() {
        return SingletonHolder.instance;
    }

    public static void stop() {
        if (hasInstance) {
            pdrFileCacheManager.getInstance().saveCacheToFile();
        }
    }

    private synchronized pdrDirectoryCache getDirectoryCache(String string, String string2) {
        pdrDirectoryCache pdrDirectoryCache2;
        pdrSourceCache pdrSourceCache2 = this.itsSourceCache.get(string);
        if (pdrSourceCache2 == null) {
            pdrSourceCache2 = new pdrSourceCache();
            this.itsSourceCache.put(string, pdrSourceCache2);
        }
        if ((pdrDirectoryCache2 = pdrSourceCache2.DirList.get(string2)) == null) {
            pdrDirectoryCache2 = new pdrDirectoryCache();
            pdrSourceCache2.DirList.put(string2, pdrDirectoryCache2);
        }
        return pdrDirectoryCache2;
    }

    public List<FtpFileInfo> processDirectoryList(String string, String string2, List<FtpFileInfo> list, boolean bl) {
        pdrDirectoryCache pdrDirectoryCache2 = this.getDirectoryCache(string, string2);
        ArrayList<FtpFileInfo> arrayList = new ArrayList<FtpFileInfo>();
        for (FtpFileInfo cloneable : list) {
            Date date = pdrDirectoryCache2.FileList.get(cloneable.getName());
            if (date == null) {
                arrayList.add(cloneable);
                continue;
            }
            if (cloneable.getModifiedDate() == null || !cloneable.getModifiedDate().after(date)) continue;
            arrayList.add(cloneable);
        }
        if (bl) {
            HashMap hashMap = new HashMap();
            for (FtpFileInfo ftpFileInfo : list) {
                hashMap.put(ftpFileInfo.getName(), ftpFileInfo);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string3 : pdrDirectoryCache2.FileList.keySet()) {
                if (hashMap.containsKey(string3)) continue;
                arrayList2.add(string3);
            }
            for (String string3 : arrayList2) {
                pdrDirectoryCache2.FileList.remove(string3);
            }
        }
        return arrayList;
    }

    public void processedFile(String string, String string2, FtpFileInfo ftpFileInfo) {
        pdrDirectoryCache pdrDirectoryCache2 = this.getDirectoryCache(string, string2);
        pdrDirectoryCache2.FileList.put(ftpFileInfo.getName(), ftpFileInfo.getModifiedDate());
        Date date = Util.dateOffset(new Date(), -this.itsCacheStateFileWriteMins, 12);
        if (this.itsLastPersisted.before(date)) {
            this.saveCacheToFile();
        }
    }

    private Map<String, pdrSourceCache> loadCacheFromFile() {
        Map<String, pdrSourceCache> map = new ConcurrentHashMap<String, pdrSourceCache>();
        this.itsLockFile = new FileLockWrapper();
        if (this.itsLockFile.setFileLock(this.itsCacheStateFile, true)) {
            try {
                String string = this.itsLockFile.readFile();
                map = (Map)JsonUtilities.fromJson(string, new TypeToken<Map<String, pdrSourceCache>>(){}.getType());
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (map != null) {
                    n2 = map.size();
                    for (pdrSourceCache pdrSourceCache2 : map.values()) {
                        if (pdrSourceCache2.DirList == null) continue;
                        for (pdrDirectoryCache pdrDirectoryCache2 : pdrSourceCache2.DirList.values()) {
                            ++n3;
                            if (pdrDirectoryCache2.FileList == null) continue;
                            n4 += pdrDirectoryCache2.FileList.size();
                        }
                    }
                }
                this.itsLastPersisted = new Date();
                Util_Logger.info(logger, "Loaded file cache state from " + this.itsCacheStateFile + ", detected " + n2 + " data sources, " + n3 + " directories, " + n4 + " files");
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error loading cache state from file " + this.itsCacheStateFile + ": " + exception.getMessage(), exception);
                Util_Logger.warning(logger, "Detected invalid or missing cache file " + this.itsCacheStateFile + ", resetting state");
            }
        } else {
            Util_Logger.errorNoRaise(logger, "Error opening " + this.itsCacheStateFile + " as it is being used by another batcher instance. Configure property batcher_file_manager_cache to a unique filename");
            System.exit(-1);
        }
        if (map == null) {
            map = new ConcurrentHashMap();
        }
        return map;
    }

    public void saveCacheToFile() {
        if (this.itsLockFile != null) {
            try {
                String string = JsonUtilities.toJson(this.itsSourceCache);
                this.itsLockFile.updateLockFile(string);
                this.itsLastPersisted = new Date();
                Util_Logger.info(logger, "Persisted state to cache state file " + this.itsCacheStateFile);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "File cache manager save failed: " + exception.getMessage(), exception);
            }
        }
    }

    private static class SingletonHolder {
        private static pdrFileCacheManager instance = new pdrFileCacheManager();

        private SingletonHolder() {
        }
    }
}

