/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Transport;

import au.com.nemmco.Pdr.Batcher.Transport.fileDetailWeb;
import au.com.nemmco.Pdr.Batcher.pdrBatcher;
import au.com.nemmco.Util.FileLockWrapper;
import au.com.nemmco.Util.JsonUtilities;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrFileWebManager {
    private static Logger logger = LoggerFactory.getLogger(pdrFileWebManager.class);
    private Map<String, fileDetailWeb> itsDirCache;
    private String itsCacheStateFile = Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_web_manager_cache", "web_manager_cache_state.txt");
    private FileLockWrapper itsLockFile;
    private Date itsLastPersisted;
    private int itsCacheStateFileWriteMins = Integer.parseInt(Util.getProperty(pdrBatcher.PROPERTIES_FILE, "batcher_web_manager_cache_write_mins", "5"));
    private static boolean hasInstance = false;

    private pdrFileWebManager() {
        this.itsDirCache = this.loadCacheFromFile();
        hasInstance = true;
    }

    public static pdrFileWebManager getInstance() {
        return SingletonHolder.instance;
    }

    public static void stop() {
        if (hasInstance) {
            pdrFileWebManager.getInstance().saveCacheToFile();
        }
    }

    private String getKey(String string, String string2, String string3) {
        return string + ":" + string2 + ":" + string3;
    }

    private boolean isLater(String string, Date date, fileDetailWeb fileDetailWeb2) {
        if (fileDetailWeb2 == null) {
            return true;
        }
        return fileDetailWeb2.isLater(string, date);
    }

    public boolean processFile(String string, String string2, String string3, String string4, Date date) {
        boolean bl = false;
        try {
            String string5 = this.getKey(string, string2, string3);
            fileDetailWeb fileDetailWeb2 = this.itsDirCache.get(string5);
            bl = this.isLater(string4, date, fileDetailWeb2);
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Error checking currency for processing file " + string4 + ": " + exception.getMessage(), exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDefaultCachePosition(String string, String string2, String string3, String string4, Date date) {
        String string5 = this.getKey(string, string2, string3);
        fileDetailWeb fileDetailWeb2 = this.itsDirCache.get(string5);
        if (fileDetailWeb2 == null) {
            fileDetailWeb fileDetailWeb3 = new fileDetailWeb();
            fileDetailWeb3.filenamesFromStr(string4);
            fileDetailWeb3.modifiedDate = date;
            Map<String, fileDetailWeb> map = this.itsDirCache;
            synchronized (map) {
                this.itsDirCache.put(string5, fileDetailWeb3);
                Util_Logger.info(logger, "Setting default cache position for " + string5 + " to " + string4 + ", timestamp " + Util.dateToStr(date, "dd/MM/yyyy HH:mm:ss"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateCache(String string, String string2, String string3, String string4, Date date) {
        if (!Util.isBlank(string4)) {
            Map<String, fileDetailWeb> map = this.itsDirCache;
            synchronized (map) {
                String string5 = this.getKey(string, string2, string3);
                fileDetailWeb fileDetailWeb2 = new fileDetailWeb();
                fileDetailWeb2.filenamesFromStr(string4);
                fileDetailWeb2.modifiedDate = date;
                fileDetailWeb fileDetailWeb3 = this.itsDirCache.get(string5);
                if (fileDetailWeb3 != null) {
                    fileDetailWeb3.updateCache(string4, date);
                } else {
                    this.setDefaultCachePosition(string, string2, string3, string4, date);
                }
                Date date2 = Util.dateOffset(new Date(), -this.itsCacheStateFileWriteMins, 12);
                if (this.itsLastPersisted.before(date2)) {
                    this.saveCacheToFile();
                }
            }
        }
    }

    private Map<String, fileDetailWeb> loadCacheFromFile() {
        Map<String, fileDetailWeb> map = new ConcurrentHashMap<String, fileDetailWeb>();
        this.itsLockFile = new FileLockWrapper();
        if (this.itsLockFile.setFileLock(this.itsCacheStateFile, true)) {
            try {
                String string = this.itsLockFile.readFile();
                map = (Map)JsonUtilities.fromJson(string, new TypeToken<Map<String, fileDetailWeb>>(){}.getType());
                this.itsLastPersisted = new Date();
                Util_Logger.info(logger, "Loaded web cache state from " + this.itsCacheStateFile);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error loading cache state from file " + this.itsCacheStateFile + ": " + exception.getMessage(), exception);
                Util_Logger.warning(logger, "Detected invalid or missing cache file " + this.itsCacheStateFile + ", resetting state");
            }
        } else {
            Util_Logger.errorNoRaise(logger, "Error opening " + this.itsCacheStateFile + " as it is being used by another batcher instance. Configure property batcher_web_manager_cache to a unique filename");
            System.exit(-1);
        }
        if (map == null) {
            map = new ConcurrentHashMap();
        }
        return map;
    }

    public void saveCacheToFile() {
        if (this.itsDirCache.size() > 0 && this.itsLockFile != null) {
            try {
                String string = JsonUtilities.toJson(this.itsDirCache);
                this.itsLockFile.updateLockFile(string);
                this.itsLastPersisted = new Date();
                Util_Logger.info(logger, "Persisted state to cache state file " + this.itsCacheStateFile);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "File cache manager save failed: " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCache() {
        Map<String, fileDetailWeb> map = this.itsDirCache;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.itsDirCache.keySet()) {
                if (string.indexOf(":BACKUP:") <= 0) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                Util_Logger.info(logger, "Clearing cache position for " + string);
                this.itsDirCache.remove(string);
            }
        }
    }

    private static class SingletonHolder {
        private static pdrFileWebManager instance = new pdrFileWebManager();

        private SingletonHolder() {
        }
    }
}

