/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common;

import au.com.nemmco.Pdr.Common.pdrDistributedLock;
import au.com.nemmco.Pdr.Common.pdrLockEngineInt;
import au.com.nemmco.Pdr.Common.pdrTaskInt;
import au.com.nemmco.Util.DistributedMessagingManager;
import au.com.nemmco.Util.Util_Logger;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrLockEngineDistributed
implements pdrLockEngineInt,
MessageListener<pdrTaskInt> {
    public static final String MESSAGE_TOPIC_COMPLETION = "PDR_JOB_COMPLETION_NOTIFICATION";
    private static Logger logger = LoggerFactory.getLogger(pdrLockEngineDistributed.class);
    private volatile Map<String, pdrDistributedLock> itsLocks = new ConcurrentHashMap<String, pdrDistributedLock>();
    private volatile Map<String, pdrTaskInt> itsLocalTasks = new ConcurrentHashMap<String, pdrTaskInt>();
    private ITopic<pdrTaskInt> itsCompletionMessage;

    @Override
    public void initialise() {
        DistributedMessagingManager distributedMessagingManager = DistributedMessagingManager.getInstance();
        this.itsCompletionMessage = distributedMessagingManager.getAgent().getTopic(MESSAGE_TOPIC_COMPLETION);
        this.itsCompletionMessage.addMessageListener((MessageListener)this);
    }

    public void onMessage(Message<pdrTaskInt> message) {
        try {
            pdrTaskInt pdrTaskInt2 = (pdrTaskInt)message.getMessageObject();
            if (!message.getPublishingMember().localMember()) {
                pdrTaskInt pdrTaskInt3;
                Util_Logger.debug(logger, "detected remote process message for file " + pdrTaskInt2.getName() + " status of " + pdrTaskInt2.getIsComplete() + " from " + message.getPublishingMember());
                if (pdrTaskInt2.getIsComplete() && (pdrTaskInt3 = this.itsLocalTasks.get(pdrTaskInt2.getName())) != null) {
                    pdrTaskInt3.setIsComplete(true);
                }
            } else {
                Util_Logger.debug(logger, "detected local process message for file " + pdrTaskInt2.getName() + " status of " + pdrTaskInt2.getIsComplete() + " from " + message.getPublishingMember());
            }
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Unable to process job completion message: " + exception.getMessage(), exception);
        }
    }

    @Override
    public synchronized boolean addTask(String string, pdrTaskInt pdrTaskInt2) {
        DistributedMessagingManager distributedMessagingManager;
        Object object;
        Util_Logger.debug(logger, "Lock Manager request for exclusive lock on " + string);
        if (pdrTaskInt2 != null) {
            this.itsLocalTasks.putIfAbsent(pdrTaskInt2.getName(), pdrTaskInt2);
        }
        ArrayList<pdrDistributedLock> arrayList = new ArrayList<pdrDistributedLock>(this.itsLocks.values());
        boolean bl = false;
        if (pdrTaskInt2 == null) {
            bl = true;
        } else {
            bl = !pdrTaskInt2.getIsComplete();
            for (pdrDistributedLock object22 : arrayList) {
                object = object22.itsTask;
                if (object == null || object.getPriority() >= pdrTaskInt2.getPriority()) continue;
                Util_Logger.debug(logger, "Lock Manager does not allow a priority " + pdrTaskInt2.getPriority() + " task (" + pdrTaskInt2.getFilename() + ") to start if a priority " + object.getPriority() + " (" + object.getFilename() + ") task is being processed");
                bl = false;
            }
        }
        boolean bl2 = false;
        if (bl && (object = (distributedMessagingManager = DistributedMessagingManager.getInstance()).getAgent().getCPSubsystem().getLock(string)).tryLock()) {
            bl2 = true;
            pdrDistributedLock pdrDistributedLock2 = new pdrDistributedLock();
            pdrDistributedLock2.itsLockEntity = string;
            pdrDistributedLock2.itsFencedLock = object;
            pdrDistributedLock2.itsTask = pdrTaskInt2;
            pdrDistributedLock2.itsThread = Thread.currentThread();
            this.itsLocks.put(string, pdrDistributedLock2);
            if (pdrTaskInt2 != null) {
                for (pdrDistributedLock pdrDistributedLock3 : arrayList) {
                    pdrTaskInt pdrTaskInt3 = pdrDistributedLock3.itsTask;
                    if (pdrTaskInt3 == null || pdrTaskInt3.getPriority() <= pdrTaskInt2.getPriority()) continue;
                    Util_Logger.debug(logger, "Lock Manager sending bump signal to low priority task " + pdrTaskInt3.getFilename());
                    pdrTaskInt3.setIsPriorityBumping(true);
                }
                pdrTaskInt2.setIsAllocated(true);
                pdrTaskInt2.setIsPriorityBumped(false);
                pdrTaskInt2.setIsPriorityBumping(false);
            }
        }
        if (bl2) {
            Util_Logger.debug(logger, "Lock Manager accepted request for exclusive lock on " + string);
        }
        Util_Logger.debug(logger, "Lock Manager contains " + this.itsLocks.size() + " entries");
        return bl2;
    }

    @Override
    public void deleteTask(String string) {
        Util_Logger.debug(logger, "Lock Manager release exclusive lock on " + string);
        pdrDistributedLock pdrDistributedLock2 = this.itsLocks.get(string);
        if (pdrDistributedLock2 != null) {
            pdrTaskInt pdrTaskInt2 = pdrDistributedLock2.itsTask;
            if (pdrTaskInt2 != null) {
                pdrTaskInt2.setIsAllocated(false);
                this.itsLocalTasks.remove(pdrTaskInt2.getName());
                if (pdrTaskInt2.getIsComplete() && pdrTaskInt2.sendCompletionMessage()) {
                    this.itsCompletionMessage.publish((Object)pdrTaskInt2);
                }
            }
            pdrDistributedLock2.itsFencedLock.unlock();
            this.itsLocks.remove(string);
            Util_Logger.debug(logger, "Lock Manager contains " + this.itsLocks.size() + " entries");
        }
    }

    @Override
    public void cleanQueue(Thread thread) {
        ArrayList<pdrDistributedLock> arrayList = new ArrayList<pdrDistributedLock>(this.itsLocks.values());
        for (pdrDistributedLock pdrDistributedLock2 : arrayList) {
            Thread thread2 = pdrDistributedLock2.itsThread;
            if (thread2 == null || !thread2.getName().equalsIgnoreCase(thread.getName())) continue;
            this.deleteTask(pdrDistributedLock2.itsLockEntity);
            Util_Logger.warning(logger, "Removing lock " + pdrDistributedLock2.itsLockEntity + " from lock manager due to dead thread " + thread.getName());
        }
    }
}

