/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common;

import au.com.nemmco.Pdr.Common.pdrLockEngineInt;
import au.com.nemmco.Pdr.Common.pdrTaskInt;
import au.com.nemmco.Util.Util_Logger;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrLockEngineInternal
implements pdrLockEngineInt {
    private static Logger logger = LoggerFactory.getLogger(pdrLockEngineInternal.class);
    private volatile Map<String, pdrTaskInt> itsTaskObjects = new HashMap<String, pdrTaskInt>();
    private volatile Map<String, Thread> itsLockEntities = new HashMap<String, Thread>();

    @Override
    public void initialise() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean addTask(String string, pdrTaskInt pdrTaskInt2) {
        Util_Logger.debug(logger, "Lock Manager request for exclusive lock on " + string);
        boolean bl = false;
        Map<String, pdrTaskInt> map = this.itsTaskObjects;
        synchronized (map) {
            Map<String, Thread> map2 = this.itsLockEntities;
            synchronized (map2) {
                if (this.itsLockEntities.get(string) == null) {
                    if (pdrTaskInt2 == null) {
                        this.itsLockEntities.put(string, Thread.currentThread());
                        bl = true;
                    } else {
                        bl = true;
                        for (pdrTaskInt object : this.itsTaskObjects.values()) {
                            if (object.getPriority() >= pdrTaskInt2.getPriority()) continue;
                            Util_Logger.debug(logger, "Lock Manager does not allow a priority " + pdrTaskInt2.getPriority() + " task (" + pdrTaskInt2.getFilename() + ") to start if a priority " + object.getPriority() + " (" + object.getFilename() + ") task is being processed");
                            bl = false;
                        }
                        if (bl) {
                            this.itsLockEntities.put(string, Thread.currentThread());
                            this.itsTaskObjects.put(string, pdrTaskInt2);
                            for (String string2 : this.itsTaskObjects.keySet()) {
                                pdrTaskInt pdrTaskInt3;
                                if (string2.equalsIgnoreCase(string) || (pdrTaskInt3 = this.itsTaskObjects.get(string2)).getPriority() <= pdrTaskInt2.getPriority()) continue;
                                Util_Logger.debug(logger, "Lock Manager sending bump signal to low priority task " + pdrTaskInt3.getFilename());
                                pdrTaskInt3.setIsPriorityBumping(true);
                            }
                            pdrTaskInt2.setIsAllocated(true);
                            pdrTaskInt2.setIsPriorityBumped(false);
                            pdrTaskInt2.setIsPriorityBumping(false);
                        }
                    }
                }
            }
        }
        if (bl) {
            Util_Logger.debug(logger, "Lock Manager accepted request for exclusive lock on " + string);
        }
        Util_Logger.debug(logger, "Lock Manager contains " + this.itsLockEntities.size() + " entries");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteTask(String string) {
        Util_Logger.debug(logger, "Lock Manager release exclusive lock on " + string);
        Map<String, pdrTaskInt> map = this.itsTaskObjects;
        synchronized (map) {
            Map<String, Thread> map2 = this.itsLockEntities;
            synchronized (map2) {
                pdrTaskInt pdrTaskInt2 = this.itsTaskObjects.get(string);
                if (pdrTaskInt2 != null) {
                    pdrTaskInt2.setIsAllocated(false);
                }
                this.itsTaskObjects.remove(string);
                this.itsLockEntities.remove(string);
            }
        }
        Util_Logger.debug(logger, "Lock Manager contains " + this.itsLockEntities.size() + " entries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanQueue(Thread thread) {
        Map<String, pdrTaskInt> map = this.itsTaskObjects;
        synchronized (map) {
            Map<String, Thread> map2 = this.itsLockEntities;
            synchronized (map2) {
                for (String string : this.itsLockEntities.keySet()) {
                    Thread thread2 = this.itsLockEntities.get(string);
                    if (!thread2.getName().equalsIgnoreCase(thread.getName())) continue;
                    this.deleteTask(string);
                    Util_Logger.warning(logger, "Removing file " + string + " from lock manager due to dead thread " + thread.getName(), null);
                }
            }
        }
    }
}

