/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Common;

import au.com.nemmco.Pdr.Common.WebAPILogger;
import au.com.nemmco.Pdr.Common.WebAPIMonitorLogger;
import au.com.nemmco.Pdr.Common.WebAPIMonitorPerformance;
import au.com.nemmco.Pdr.Common.WebAPIMonitorReceipt;
import au.com.nemmco.Pdr.Common.pdrLoggerRec;
import au.com.nemmco.Pdr.Common.pdrMonitorConfig;
import au.com.nemmco.Pdr.Common.pdrMonitorDataSet;
import au.com.nemmco.Pdr.Common.pdrMonitorLogger;
import au.com.nemmco.Pdr.Common.pdrMonitorRec;
import au.com.nemmco.Pdr.Common.pdrPerformanceRec;
import au.com.nemmco.Pdr.Common.perfFileFilter;
import au.com.nemmco.Util.ApplicationInt;
import au.com.nemmco.Util.FileComparator;
import au.com.nemmco.Util.FileUtilities;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebServer;
import au.com.nemmco.Util.XmlUtilities;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrMonitorManager {
    private static Logger logger = LoggerFactory.getLogger(pdrMonitorManager.class);
    public static String TYPE_LOGGER = "logger";
    public static String TYPE_PERF = "perf";
    private volatile List<pdrMonitorRec> itsPerfRecords;
    private volatile List<pdrMonitorRec> itsLogRecords;
    private String itsAppName;
    private String itsAppVersion;
    private String itsAppInstanceId;
    private String itsHostname;
    private String itsOverflowDir;
    private int itsMaxCacheRecords;
    private DateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    private String itsRemoteUUID;

    private pdrMonitorManager() {
        this.itsPerfRecords = new ArrayList<pdrMonitorRec>();
        this.itsLogRecords = new ArrayList<pdrMonitorRec>();
    }

    public static pdrMonitorManager getInstance() {
        return SingletonHolder.instance;
    }

    public void init(pdrMonitorConfig pdrMonitorConfig2) {
        this.itsAppInstanceId = pdrMonitorConfig2.itsAppInstanceId;
        this.itsOverflowDir = pdrMonitorConfig2.itsOverflowDir;
        this.itsMaxCacheRecords = pdrMonitorConfig2.itsMaxCacheRecords;
        if (pdrMonitorConfig2.enableListener) {
            Util_Logger.addListener(new pdrMonitorLogger());
        } else {
            Util_Logger.warning(logger, "Disabling pdrMonitor as performance_overflow_dir is not defined");
        }
        WebServer.getInstance().addHandler(WebAPIMonitorPerformance.class);
        WebServer.getInstance().addHandler(WebAPIMonitorLogger.class);
        WebServer.getInstance().addHandler(WebAPIMonitorReceipt.class);
        WebServer.getInstance().addHandler(WebAPILogger.class);
    }

    public void init(Properties properties) {
        pdrMonitorConfig pdrMonitorConfig2 = new pdrMonitorConfig();
        pdrMonitorConfig2.itsAppInstanceId = Util.getProperty(properties, "instance_identifier", "");
        pdrMonitorConfig2.itsOverflowDir = Util.getProperty(properties, "performance_overflow_dir", null);
        pdrMonitorConfig2.itsMaxCacheRecords = Integer.parseInt(Util.getProperty(properties, "performance_cache_max_queue_size", "100"));
        pdrMonitorConfig2.enableListener = !Util.isBlank(pdrMonitorConfig2.itsOverflowDir);
        this.init(pdrMonitorConfig2);
    }

    public void setAppDetails(ApplicationInt applicationInt) {
        this.itsHostname = System.getProperty("hostname");
        this.itsAppName = applicationInt.getAppName();
        this.itsAppVersion = applicationInt.getAppVersion();
    }

    private void updateRec(pdrMonitorRec pdrMonitorRec2) {
        pdrMonitorRec2.setAppName(this.itsAppName);
        pdrMonitorRec2.setAppVersion(this.itsAppVersion);
        pdrMonitorRec2.setAppInstanceId(this.itsAppInstanceId);
        pdrMonitorRec2.setHostName(this.itsHostname);
    }

    public synchronized void checkUUID(String string) {
        if (string != null) {
            if (this.itsRemoteUUID != null && !this.itsRemoteUUID.equalsIgnoreCase(string)) {
                Util_Logger.warning(logger, "Detected new pdrMonitor instance connecting to this application");
            }
            this.itsRemoteUUID = string;
        }
    }

    public void addRecord(pdrMonitorRec pdrMonitorRec2) {
        this.updateRec(pdrMonitorRec2);
        List<pdrMonitorRec> list = null;
        String string = null;
        if (pdrMonitorRec2 instanceof pdrLoggerRec) {
            list = this.itsLogRecords;
            string = TYPE_LOGGER;
        } else if (pdrMonitorRec2 instanceof pdrPerformanceRec) {
            list = this.itsPerfRecords;
            string = TYPE_PERF;
        }
        if (list != null) {
            list.add(pdrMonitorRec2);
            if (!Util.isBlank(this.itsOverflowDir)) {
                if (list.size() > 2 * this.itsMaxCacheRecords) {
                    try {
                        this.flushList(string, list, this.itsMaxCacheRecords);
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error flushing " + string + " data cache: " + exception.getMessage(), exception);
                    }
                }
            } else {
                while (list.size() > this.itsMaxCacheRecords) {
                    list.remove(list.size() - 1);
                }
            }
        }
    }

    private String getTransactionFilename(String string) {
        String string2 = this.itsAppInstanceId + "_" + string + ".xml";
        return this.itsOverflowDir + "/" + string2;
    }

    private String serializeLogRecords(pdrMonitorDataSet pdrMonitorDataSet2) {
        XStream xStream = XmlUtilities.getConverter();
        xStream.processAnnotations(pdrMonitorDataSet.class);
        xStream.processAnnotations(pdrLoggerRec.class);
        xStream.processAnnotations(pdrPerformanceRec.class);
        return xStream.toXML((Object)pdrMonitorDataSet2);
    }

    private String persistToFile(pdrMonitorDataSet pdrMonitorDataSet2, String string) throws IOException {
        String string2 = this.formatter.format(new Date()) + "_" + string;
        pdrMonitorDataSet2.setTransactionId(string2);
        String string3 = this.serializeLogRecords(pdrMonitorDataSet2);
        String string4 = this.getTransactionFilename(string2);
        try (PrintWriter printWriter = new PrintWriter(string4);){
            printWriter.println(string3);
        }
        return string3;
    }

    private String checkOverflow(String string) throws IOException {
        String string2 = null;
        File file = new File(this.itsOverflowDir);
        perfFileFilter perfFileFilter2 = new perfFileFilter(this.itsAppInstanceId, string);
        File[] fileArray = file.listFiles(perfFileFilter2);
        if (fileArray != null && fileArray.length > 0) {
            Arrays.sort(fileArray, FileComparator.getComparator("OLDEST"));
            string2 = new String(Files.readAllBytes(fileArray[0].toPath()));
        }
        return string2;
    }

    public void stop() {
        try {
            this.flushList(TYPE_LOGGER, this.itsLogRecords, -1);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error flushing log data to disk: " + exception.getMessage(), exception);
        }
        try {
            this.flushList(TYPE_PERF, this.itsPerfRecords, -1);
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error flushing performance data to disk: " + exception.getMessage(), exception);
        }
    }

    private pdrMonitorDataSet<pdrMonitorRec> buildMonitorDataSet(List<pdrMonitorRec> list, int n2) throws Exception {
        pdrMonitorDataSet<pdrMonitorRec> pdrMonitorDataSet2 = new pdrMonitorDataSet<pdrMonitorRec>();
        int n3 = list.size();
        if (n2 > 0) {
            n3 = Math.min(list.size(), this.itsMaxCacheRecords);
        }
        pdrMonitorDataSet2.addData(list.subList(0, n3));
        return pdrMonitorDataSet2;
    }

    private String flushList(String string, List<pdrMonitorRec> list, int n2) throws Exception {
        String string2 = null;
        if (!Util.isBlank(this.itsOverflowDir)) {
            pdrMonitorDataSet<pdrMonitorRec> pdrMonitorDataSet2 = this.buildMonitorDataSet(list, n2);
            string2 = this.persistToFile(pdrMonitorDataSet2, string);
            for (pdrMonitorRec pdrMonitorRec2 : pdrMonitorDataSet2.getMonitorRecs()) {
                list.remove(pdrMonitorRec2);
            }
            Util_Logger.info(logger, "Flushed internal monitor cache for " + string + " records, cache now has " + list.size() + " records");
        }
        return string2;
    }

    private String getLatestRecs(String string, List<pdrMonitorRec> list) throws Exception {
        String string2 = null;
        if (!Util.isBlank(this.itsOverflowDir)) {
            string2 = list.size() > 0 ? this.flushList(string, list, this.itsMaxCacheRecords) : this.checkOverflow(string);
        } else {
            pdrMonitorDataSet<pdrMonitorRec> pdrMonitorDataSet2 = this.buildMonitorDataSet(list, -1);
            string2 = this.serializeLogRecords(pdrMonitorDataSet2);
        }
        return string2;
    }

    public String getLatestPerfRecs() throws Exception {
        return this.getLatestRecs(TYPE_PERF, this.itsPerfRecords);
    }

    public String getLatestLogRecs() throws Exception {
        return this.getLatestRecs(TYPE_LOGGER, this.itsLogRecords);
    }

    public List<pdrMonitorRec> getCurrentLogRecs() throws Exception {
        return this.itsLogRecords;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean acknowledgeReceipt(String string) throws Exception {
        boolean bl = false;
        if (Util.isInteger(string.substring(0, 1))) {
            String string2 = this.getTransactionFilename(string);
            if (FileUtilities.fileExists(string2)) {
                if (!FileUtilities.deleteFile(string2)) throw new Exception("Detected error acknowledging TransactionId " + string);
                Util_Logger.info(logger, "Processed acknowledgement receipt for TransactionId " + string);
                return true;
            }
            Util_Logger.warning(logger, "Received acknowledgement receipt for TransactionId " + string + " which has aready been acknowledged");
            return bl;
        } else {
            Util_Logger.error(logger, "Invalid TransactionId detected: " + string);
        }
        return bl;
    }

    private static class SingletonHolder {
        private static pdrMonitorManager instance = new pdrMonitorManager();

        private SingletonHolder() {
        }
    }
}

