/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

class CIDRUtils {
    private final String cidr;
    private InetAddress inetAddress;
    private InetAddress startAddress;
    private InetAddress endAddress;
    private final int prefixLength;

    public CIDRUtils(String string) throws UnknownHostException {
        this.cidr = string;
        if (!this.cidr.contains("/")) {
            throw new IllegalArgumentException("not an valid CIDR format!");
        }
        int n2 = this.cidr.indexOf("/");
        String string2 = this.cidr.substring(0, n2);
        String string3 = this.cidr.substring(n2 + 1);
        this.inetAddress = InetAddress.getByName(string2);
        this.prefixLength = Integer.parseInt(string3);
        this.calculate();
    }

    private void calculate() throws UnknownHostException {
        int n2;
        ByteBuffer byteBuffer;
        if (this.inetAddress.getAddress().length == 4) {
            byteBuffer = ByteBuffer.allocate(4).putInt(-1);
            n2 = 4;
        } else {
            byteBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
            n2 = 16;
        }
        BigInteger bigInteger = new BigInteger(1, byteBuffer.array()).not().shiftRight(this.prefixLength);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.inetAddress.getAddress());
        BigInteger bigInteger2 = new BigInteger(1, byteBuffer2.array());
        BigInteger bigInteger3 = bigInteger2.and(bigInteger);
        BigInteger bigInteger4 = bigInteger3.add(bigInteger.not());
        byte[] byArray = this.toBytes(bigInteger3.toByteArray(), n2);
        byte[] byArray2 = this.toBytes(bigInteger4.toByteArray(), n2);
        this.startAddress = InetAddress.getByAddress(byArray);
        this.endAddress = InetAddress.getByAddress(byArray2);
    }

    private byte[] toBytes(byte[] byArray, int n2) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i2 = 0; i2 < n2 && byArray.length - 1 - i2 >= 0; ++i2) {
            arrayList.add(0, byArray[byArray.length - 1 - i2]);
        }
        int n3 = arrayList.size();
        for (int i3 = 0; i3 < n2 - n3; ++i3) {
            arrayList.add(0, (byte)0);
        }
        byte[] byArray2 = new byte[arrayList.size()];
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            byArray2[i4] = (Byte)arrayList.get(i4);
        }
        return byArray2;
    }

    public String getNetworkAddress() {
        return this.startAddress.getHostAddress();
    }

    public String getBroadcastAddress() {
        return this.endAddress.getHostAddress();
    }

    public boolean isInRange(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        BigInteger bigInteger = new BigInteger(1, this.startAddress.getAddress());
        BigInteger bigInteger2 = new BigInteger(1, this.endAddress.getAddress());
        BigInteger bigInteger3 = new BigInteger(1, inetAddress.getAddress());
        int n2 = bigInteger.compareTo(bigInteger3);
        int n3 = bigInteger3.compareTo(bigInteger2);
        return !(n2 != -1 && n2 != 0 || n3 != -1 && n3 != 0);
    }
}

