/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationDataVaultManager;
import au.com.nemmco.Util.Crypt;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationValueResolver {
    private static Logger logger = LoggerFactory.getLogger(ConfigurationValueResolver.class);
    private static final String START_CONST = "${";
    private static final String END_CONST = "}";
    private static final String PREFIX_ENV = "env:";
    private static final String PREFIX_SYS = "sys:";
    private static final String PREFIX_VAULT = "vault:";
    private static final String PREFIX_DATE = "date:";
    private static final int MAX_SUBST_DEPTH = 5;
    private static final Map<String, String> ENV = System.getenv();

    public String resolveValue(String string, boolean bl) {
        return this.resolveValue(string, bl, 0);
    }

    public String resolveExternalVariable(String string, int n2) {
        return null;
    }

    public String resolveValue(String object, boolean bl, int n2) {
        if (object != null) {
            int n3 = 0;
            int n4 = ((String)object).indexOf(START_CONST, n3);
            while (n4 != -1) {
                Object object2;
                Object object3;
                if (n2 + 1 > 5) {
                    return object;
                }
                int n5 = ((String)object).indexOf(END_CONST, n4);
                if (n5 == -1) {
                    return object;
                }
                String string = ((String)object).substring(n4 + START_CONST.length(), n5);
                String string2 = null;
                boolean bl2 = false;
                if (string.startsWith(PREFIX_ENV)) {
                    object3 = string.substring(PREFIX_ENV.length());
                    int n6 = ((String)object3).indexOf(":");
                    if (n6 > 0) {
                        object2 = ((String)object3).substring(0, n6);
                        if (((String)object2).equalsIgnoreCase("decrypt")) {
                            bl2 = true;
                        } else {
                            Util_Logger.warning(logger, "Unsupported operation [" + (String)object2 + "] detected for variable " + string + ". Only supported option is decrypt");
                        }
                        object3 = ((String)object3).substring(n6 + 1);
                    }
                    string2 = ENV.get(object3);
                } else if (string.startsWith(PREFIX_SYS)) {
                    object3 = string.substring(PREFIX_SYS.length());
                    int n7 = ((String)object3).indexOf(":");
                    if (n7 > 0) {
                        object2 = ((String)object3).substring(0, n7);
                        if (((String)object2).equalsIgnoreCase("decrypt")) {
                            bl2 = true;
                        } else {
                            Util_Logger.warning(logger, "Unsupported operation [" + (String)object2 + "] detected for variable " + string + ". Only supported option is decrypt");
                        }
                        object3 = ((String)object3).substring(n7 + 1);
                    }
                    string2 = System.getProperty((String)object3);
                } else if (string.startsWith(PREFIX_VAULT)) {
                    if (bl) {
                        object3 = string.substring(PREFIX_VAULT.length());
                        ApplicationDataVaultManager applicationDataVaultManager = ApplicationDataVaultManager.getInstance();
                        string2 = applicationDataVaultManager.getValue((String)object3);
                    }
                } else if (string.startsWith(PREFIX_DATE)) {
                    object3 = string.substring(PREFIX_DATE.length());
                    int n8 = ((String)object3).indexOf(":");
                    if (n8 > 0) {
                        object2 = null;
                        String string3 = ((String)object3).substring(0, n8).toLowerCase();
                        if (string3.equalsIgnoreCase("today")) {
                            object2 = new Date();
                        } else if (string3.equalsIgnoreCase("tomorrow")) {
                            object2 = Util.dateOffset(new Date(), 1, 5);
                        } else if (string3.equalsIgnoreCase("yesterday")) {
                            object2 = Util.dateOffset(new Date(), -1, 5);
                        } else if (string3.startsWith("today")) {
                            int n9 = Integer.parseInt(string3.substring(5));
                            object2 = Util.dateOffset(new Date(), n9, 5);
                        } else {
                            Util_Logger.warning(logger, "Unsupported date [" + string3 + "] detected for variable " + string);
                        }
                        if (object2 != null) {
                            String string4 = ((String)object3).substring(n8 + 1);
                            string2 = Util.dateToStr((Date)object2, string4);
                        }
                    } else {
                        Util_Logger.warning(logger, "Missing date format detected for variable " + string);
                    }
                } else {
                    string2 = this.resolveExternalVariable(string, n2 + 1);
                }
                if (string2 == null) {
                    return object;
                }
                if (bl2) {
                    try {
                        object3 = Crypt.getInstance();
                        string2 = ((Crypt)object3).decrypt(string2);
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Unable to decrypt variable " + string + ": " + exception.getMessage(), exception);
                        return object;
                    }
                }
                object3 = n4 > 0 ? ((String)object).substring(0, n4) : "";
                object3 = (String)object3 + string2;
                n3 = ((String)object3).length();
                object = object3 = (String)object3 + ((String)object).substring(n5 + 1);
                n4 = ((String)object).indexOf(START_CONST, n3);
            }
        }
        return object;
    }
}

