/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.DatabaseConfig;
import au.com.nemmco.Util.DbHandler;
import au.com.nemmco.Util.DbHandlerField;
import au.com.nemmco.Util.DbManager;
import au.com.nemmco.Util.DbPreparedStatementParam;
import au.com.nemmco.Util.DbSpaceStats;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbHandlerMySQL
extends DbHandler {
    private static Logger logger = LoggerFactory.getLogger(DbHandlerMySQL.class);

    public DbHandlerMySQL(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        super(databaseConfig, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterConnect(Connection connection) throws SQLException {
        Statement statement = null;
        try {
            connection.setTransactionIsolation(2);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Map<String, DbHandlerField> getColumnList(Connection connection, String string, String string2) throws ApplicationException {
        HashMap<String, DbHandlerField> hashMap = new HashMap<String, DbHandlerField>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String string3 = "SELECT column_name,data_type ,IFNULL(numeric_precision,character_maximum_length) as length ,numeric_scale FROM information_schema.COLUMNS C where lower(table_name) = '" + string2.toLowerCase() + "'" + (String)(Util.isBlank(string) ? "" : " and lower(table_schema) = '" + string.toLowerCase() + "'") + " order by ordinal_position";
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                DbHandlerField dbHandlerField = new DbHandlerField(resultSet.getString(1), resultSet.getString(2), this.maptoFieldTypeId(resultSet.getString(2)), resultSet.getInt(3), resultSet.getInt(4), hashMap.size());
                hashMap.put(dbHandlerField.getFieldName().toUpperCase(), dbHandlerField);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getColumnList: " + sQLException.getMessage(), sQLException);
        }
        return hashMap;
    }

    @Override
    public List<String> getPkList(Connection connection, String string, String string2) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String string3 = "SELECT column_name,data_type ,IFNULL(numeric_precision,character_maximum_length) as length FROM information_schema.COLUMNS C where lower(table_name) = '" + string2.toLowerCase() + "'" + (String)(Util.isBlank(string) ? "" : " and lower(table_schema) = '" + string.toLowerCase() + "'") + " and column_key = 'PRI' order by ordinal_position";
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                if (string4 == null) continue;
                arrayList.add(string4.toUpperCase());
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getPkList: " + sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    @Override
    public long getSequence(Connection connection, String string, String string2) throws ApplicationException {
        long l2 = -1L;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select " + this.getTableReference(string, string2) + "()");
            while (resultSet.next()) {
                l2 = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Util_Logger.error(logger, "Detected error in getSequence: " + sQLException.getMessage(), sQLException);
        }
        return l2;
    }

    @Override
    public String getCurrentDateTime() {
        return "NOW()";
    }

    @Override
    public String getCurrentUser() {
        return "CURRENT_USER()";
    }

    @Override
    public String getNoTable() {
        return "from dual";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbSpaceStats> getSpaceUsage() throws ApplicationException {
        ArrayList<DbSpaceStats> arrayList = new ArrayList<DbSpaceStats>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbManager.getDbConnection();
            statement = connection.createStatement();
            String string = "SELECT DATABASE() AS db_name, SUM(data_length + index_length) AS used_bytes FROM information_schema.TABLES where table_schema = DATABASE()" + this.getTablespaceToReportSQL("and", "DATABASE()") + " group by DATABASE() order by DATABASE()";
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                DbSpaceStats dbSpaceStats = new DbSpaceStats(resultSet.getString("db_name"));
                dbSpaceStats.setUsedBytes(resultSet.getLong("used_bytes"));
                arrayList.add(dbSpaceStats);
            }
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error extracting database space statistics: " + exception.getMessage(), exception);
        }
        finally {
            DbManager.freeDbConnection(connection, statement, resultSet);
        }
        return arrayList;
    }

    @Override
    public String getSqlDate(Date date) {
        return this.getSqlDate(Util.dateToStr(date, this.getJavaDateFormat()));
    }

    @Override
    public String getSqlDate(String string) {
        return "str_to_date('" + string + "','" + this.getDbDateFormat() + "')";
    }

    @Override
    public String concatStr(String string, String string2) {
        return "CONCAT(" + string + "," + string2 + ")";
    }

    @Override
    public String getDateFieldFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME")) {
            return this.getJavaDateFormat();
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("TIMESTAMP")) {
            return this.getJavaTimestampFormat();
        }
        return null;
    }

    private boolean isDateField(DbHandlerField dbHandlerField) {
        return dbHandlerField.getFieldType().equalsIgnoreCase("TIMESTAMP") || dbHandlerField.getFieldType().equalsIgnoreCase("DATETIME");
    }

    @Override
    public DbPreparedStatementParam getSqlPreparedStatementFormat(DbHandlerField dbHandlerField) {
        if (dbHandlerField == null) {
            return new DbPreparedStatementParam("?", 12);
        }
        if (this.isDateField(dbHandlerField)) {
            return new DbPreparedStatementParam("str_to_date(?,'" + this.getDbDateFormat() + "')", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("DECIMAL")) {
            return new DbPreparedStatementParam("cast(? as DECIMAL(" + dbHandlerField.getDataLength() + "," + dbHandlerField.getDataScale() + "))", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("INT")) {
            return new DbPreparedStatementParam("cast(? as SIGNED)", 12);
        }
        if (dbHandlerField.getFieldType().equalsIgnoreCase("CHAR")) {
            return new DbPreparedStatementParam(this.rightPad("?", dbHandlerField.getDataLength()), 12);
        }
        return new DbPreparedStatementParam("?", 12);
    }

    @Override
    public boolean isValid(Connection connection) {
        boolean bl;
        block5: {
            bl = false;
            if (connection != null) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.executeQuery("select NOW()");
                    statement.close();
                    bl = true;
                }
                catch (Exception exception) {
                    Util_Logger.warning(logger, "Error on SQL connection: " + exception.getMessage(), exception);
                    if (statement == null) break block5;
                    try {
                        statement.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        return bl;
    }

    @Override
    public String ifNull(String string, String string2) {
        return "IFNULL(" + string + "," + string2 + ")";
    }

    private String rightPad(String string, int n2) {
        return "RPAD(" + string + "," + n2 + ",' ')";
    }

    @Override
    public String getSqlRowLimited(String string, String string2, int n2) {
        return "SELECT " + string + " ORDER BY " + string2 + " LIMIT 0," + n2;
    }

    @Override
    public String getBitOperator(String string, String string2) {
        return "(" + string + " & " + string2 + ")";
    }

    @Override
    public String getSqlDateRoundUp(String string, int n2) throws Exception {
        return "date_add(date_add(" + string + ", INTERVAL -time_to_sec(" + string + ") SECOND), INTERVAL (floor((time_to_sec(" + string + ")-1)/(" + n2 + "*60))+1)*" + n2 + " MINUTE)";
    }

    @Override
    public String getSqlDateDiffInSecs(String string, String string2) {
        return "TIMESTAMPDIFF(MICROSECOND," + string + "," + string2 + ")/1000";
    }

    @Override
    public String getSqlDateAdd(String string, String string2, int n2) throws Exception {
        switch (n2) {
            case 13: {
                return "(" + string + ", INTERVAL " + string2 + " SECOND)";
            }
            case 12: {
                return "DATE_ADD(" + string + ", INTERVAL " + string2 + " MINUTE)";
            }
            case 11: {
                return "DATE_ADD(" + string + ", INTERVAL " + string2 + " HOUR)";
            }
            case 5: {
                return "DATE_ADD(" + string + ", INTERVAL " + string2 + " DAY)";
            }
        }
        throw new Exception("Unsupported operation getSqlDateAdd for Calendar field ID " + n2);
    }
}

