/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.Util_Logger;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(DirectoryWatcher.class);
    public String itsDirectory;
    private volatile boolean itsIsRunning = true;
    private volatile boolean detectedFile = false;

    public DirectoryWatcher(String string) {
        this.itsDirectory = string;
    }

    public void waitForFile(long l2) {
        try {
            int n2 = 0;
            Util_Logger.debug(logger, "Sleeping for " + l2 + "ms waiting for file watch event");
            while (!this.detectedFile && (long)n2 < l2) {
                Thread.sleep(100L);
                n2 += 100;
            }
            this.detectedFile = false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void monitor() {
        WatchService watchService = null;
        while (this.itsIsRunning) {
            try {
                WatchKey watchKey;
                watchService = FileSystems.getDefault().newWatchService();
                Path path = Paths.get(this.itsDirectory, new String[0]);
                WatchKey watchKey2 = path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE);
                Util_Logger.info(logger, "Watch service registered for dir: " + path.toString());
                do {
                    watchKey = null;
                    try {
                        watchKey = watchService.take();
                        watchKey.pollEvents();
                        Thread.sleep(50L);
                        this.detectedFile = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (watchKey.reset());
                Util_Logger.errorNoRaise(logger, "Directory watch on " + this.itsDirectory + " is now invalid");
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Detected error in directory watch service [" + this.itsDirectory + "] : " + exception.getMessage(), exception);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (watchService != null) {
            try {
                watchService.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Util_Logger.info(logger, "Directory watch service [" + this.itsDirectory + "] closed");
        }
    }

    @Override
    public void run() {
        this.monitor();
    }

    public void stop() {
        this.itsIsRunning = false;
    }

    public boolean getIsRunning() {
        return this.itsIsRunning;
    }
}

