/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.FtpFileInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class FileUtilities {
    public static boolean deleteRecursive(File file, FilenameFilter filenameFilter) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        boolean bl = true;
        if (file.isDirectory()) {
            for (File file2 : file.listFiles(filenameFilter)) {
                bl = bl && FileUtilities.deleteRecursive(file2, filenameFilter);
            }
        } else {
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean deleteRecursive(String string, FilenameFilter filenameFilter) throws FileNotFoundException {
        return FileUtilities.deleteRecursive(new File(string), filenameFilter);
    }

    public static boolean fileExists(String string) throws IOException {
        Path path = Paths.get(string, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean fileExists(File file) throws IOException {
        Path path = Paths.get(file.getPath(), new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean deleteFile(File file) throws IOException {
        Path path = Paths.get(file.getPath(), new String[0]);
        return Files.deleteIfExists(path);
    }

    public static boolean deleteFile(String string) throws IOException {
        Path path = Paths.get(string, new String[0]);
        return Files.deleteIfExists(path);
    }

    public static boolean deleteFile(FtpFileInfo ftpFileInfo) throws IOException {
        Path path = Paths.get(ftpFileInfo.getDirectory(), ftpFileInfo.getFilename());
        return Files.deleteIfExists(path);
    }

    public static void renameFile(String string, String string2) throws IOException {
        Path path = Paths.get(string, new String[0]);
        Path path2 = Paths.get(string2, new String[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.move(path, path2, copyOptionArray);
    }

    public static void renameFile(File file, File file2) throws IOException {
        FileUtilities.renameFile(file.getPath(), file2.getPath());
    }

    public static void copy(File file, File file2) throws IOException {
        Path path = Paths.get(file.getPath(), new String[0]);
        Path path2 = Paths.get(file2.getPath(), new String[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
        Files.copy(path, path2, copyOptionArray);
    }

    public static void archiveFile(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string2 + File.separator);
        file2.mkdirs();
        File file3 = new File(file2, file.getName());
        FileUtilities.renameFile(file, file3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileIsNotLocked(String string) {
        boolean bl = false;
        File file = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        FileLock fileLock = null;
        try {
            file = new File(string);
            abstractInterruptibleChannel = new RandomAccessFile(file, "rw").getChannel();
            fileLock = ((FileChannel)abstractInterruptibleChannel).tryLock();
            if (fileLock != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fileLock != null && fileLock.isValid()) {
                    fileLock.release();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                file = null;
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static synchronized void touch(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

