/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.FtpConnectionInt;
import au.com.nemmco.Util.FtpConnectionPoolFactory;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpConnectionPool {
    private static Logger logger = LoggerFactory.getLogger(FtpConnectionPool.class);
    private volatile GenericObjectPool<FtpConnectionInt> itsPool;
    private Date itsPoolLastCleared;
    private int itsPoolTimeoutMins;
    private String itsId;
    private String itsConfigId;
    private Properties itsConfiguration;
    private FtpConnectionPoolFactory itsFactory;

    public FtpConnectionPool(String string, Properties properties, String string2) {
        this.itsId = string;
        this.itsConfigId = "";
        if (!Util.isBlank(this.itsId)) {
            this.itsConfigId = this.itsId + "_";
        }
        this.itsConfiguration = properties;
        this.itsFactory = new FtpConnectionPoolFactory(string, properties, string2){

            @Override
            public synchronized PooledObject<FtpConnectionInt> makeObject() throws Exception {
                PooledObject<FtpConnectionInt> pooledObject = super.makeObject();
                FtpConnectionPool.this.logConnectionPoolState(1);
                return pooledObject;
            }

            @Override
            public void destroyObject(PooledObject<FtpConnectionInt> pooledObject) throws Exception {
                super.destroyObject(pooledObject);
                FtpConnectionPool.this.logConnectionPoolState(0);
            }
        };
        this.createFtpConnectionPool();
    }

    public String getId() {
        return this.itsId;
    }

    private void createFtpConnectionPool() {
        if (this.itsPool != null) {
            try {
                this.itsPool.clear();
                this.itsPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setBlockWhenExhausted(true);
        genericObjectPoolConfig.setMaxTotal(Integer.parseInt(Util.getProperty(this.itsConfiguration, "batcher_" + this.itsConfigId + "ftp_max_connections", "5")));
        genericObjectPoolConfig.setTestWhileIdle(true);
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis((long)(Integer.parseInt(Util.getProperty(this.itsConfiguration, "batcher_" + this.itsConfigId + "ftp_eviction_cycle", "120")) * 1000));
        genericObjectPoolConfig.setMinEvictableIdleTimeMillis((long)(Integer.parseInt(Util.getProperty(this.itsConfiguration, "batcher_" + this.itsConfigId + "ftp_eviction_timeout", "1800")) * 1000));
        genericObjectPoolConfig.setTestOnBorrow(true);
        genericObjectPoolConfig.setTestOnReturn(true);
        genericObjectPoolConfig.setLifo(true);
        genericObjectPoolConfig.setMaxWaitMillis((long)(Integer.parseInt(Util.getProperty(this.itsConfiguration, "batcher_" + this.itsConfigId + "ftp_max_wait", "30")) * 1000));
        this.itsPool = new GenericObjectPool((PooledObjectFactory)this.itsFactory);
        this.itsPool.setConfig(genericObjectPoolConfig);
        this.itsPoolLastCleared = new Date();
        this.itsPoolTimeoutMins = Integer.parseInt(Util.getProperty(this.itsConfiguration, "batcher_ftp_" + this.itsConfigId + "pool_timeout", "10"));
    }

    public FtpConnectionInt getConnection() {
        FtpConnectionInt ftpConnectionInt = null;
        try {
            ftpConnectionInt = (FtpConnectionInt)this.itsPool.borrowObject();
            ftpConnectionInt.chdir("/");
            ftpConnectionInt.setType("binary");
            ftpConnectionInt.resetBandwidthThrottle();
            Util_Logger.debug(logger, "Borrowed FTP connection [" + ftpConnectionInt.getId() + "]");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to borrow FTP connection from object pool: " + exception.getMessage(), exception);
        }
        return ftpConnectionInt;
    }

    public void returnConnection(FtpConnectionInt ftpConnectionInt) {
        if (ftpConnectionInt != null) {
            try {
                Util_Logger.debug(logger, "Returned FTP connection [" + ftpConnectionInt.getId() + "]");
                ftpConnectionInt.resetBandwidthThrottle();
                this.itsPool.returnObject((Object)ftpConnectionInt);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to return FTP connection to object pool: " + exception.getMessage(), exception);
            }
        }
    }

    private void logConnectionPoolState(int n2) {
        if (this.itsPool != null) {
            Util_Logger.info(logger, "FTP Connection pool [" + this.itsId + "] now has a total of " + (this.itsPool.getNumActive() + n2) + " active connections, " + this.itsPool.getNumIdle() + " idle connections");
        }
    }

    public synchronized void clearCache() {
        try {
            Date date = Util.dateOffset(new Date(), -this.itsPoolTimeoutMins, 12);
            if (this.itsPoolLastCleared.before(date)) {
                this.createFtpConnectionPool();
                Util_Logger.warning(logger, "Flushed FTP connection pool");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error clearing object pool cache for FtpConnectionPool:" + exception.getMessage(), exception);
        }
    }
}

