/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.FileLockWrapper;
import au.com.nemmco.Util.Util;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLockManager {
    private static Logger logger = LoggerFactory.getLogger(InstanceLockManager.class);
    private FileLockWrapper itsLockFile;

    private InstanceLockManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                InstanceLockManager.releaseLock();
            }
        });
    }

    public static InstanceLockManager getInstance() {
        return SingletonHolder.instance;
    }

    public boolean setLock(String string) {
        this.itsLockFile = new FileLockWrapper();
        return this.itsLockFile.setFileLock(string, false);
    }

    public void touchLockFile() {
        if (this.itsLockFile != null) {
            this.itsLockFile.updateLockFile(Util.dateToStr(new Date(), "dd/MM/yyyy HH:mm:ss"));
        }
    }

    public static void releaseLock() {
        InstanceLockManager instanceLockManager = InstanceLockManager.getInstance();
        instanceLockManager.releaseFileLock();
    }

    private void releaseFileLock() {
        if (this.itsLockFile != null) {
            this.itsLockFile.releaseFileLock();
        }
    }

    private static class SingletonHolder {
        private static InstanceLockManager instance = new InstanceLockManager();

        private SingletonHolder() {
        }
    }
}

