/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationException;
import au.com.nemmco.Util.Util_Logger;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerManager {
    private static Logger logger = LoggerFactory.getLogger(JobSchedulerManager.class);
    private Scheduler itsJobScheduler;

    private JobSchedulerManager() {
    }

    public static JobSchedulerManager getInstance() {
        return SingletonHolder.instance;
    }

    private synchronized Scheduler getScheduler() throws SchedulerException {
        if (this.itsJobScheduler == null) {
            this.itsJobScheduler = new StdSchedulerFactory().getScheduler();
        }
        return this.itsJobScheduler;
    }

    public void scheduleJob(String string, String string2, String string3, Job job, Map<String, String> map) throws ApplicationException {
        try {
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(string2, string).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)string3)).build();
            JobBuilder jobBuilder = JobBuilder.newJob(job.getClass());
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("NAME", string2);
            for (Map.Entry<String, String> scheduler2 : map.entrySet()) {
                jobDataMap.put(scheduler2.getKey(), scheduler2.getValue());
            }
            JobDetail jobDetail = jobBuilder.usingJobData(jobDataMap).withIdentity(string2, string).build();
            Scheduler scheduler = this.getScheduler();
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error scheduling job " + string2 + " on CRON schedule " + string3 + ": " + exception.getMessage(), exception);
        }
    }

    public void start() throws ApplicationException {
        try {
            if (this.itsJobScheduler != null && !this.itsJobScheduler.isStarted()) {
                this.itsJobScheduler.start();
                Util_Logger.info(logger, "Started job scheduling system");
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error starting job scheduler: " + exception.getMessage(), exception);
        }
    }

    public void stop() {
        try {
            if (this.itsJobScheduler != null && this.itsJobScheduler.isStarted()) {
                this.itsJobScheduler.shutdown();
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error stopping job scheduler: " + exception.getMessage(), exception);
        }
    }

    private static class SingletonHolder {
        private static JobSchedulerManager instance = new JobSchedulerManager();

        private SingletonHolder() {
        }
    }
}

