/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.AuthenticationManager;
import au.com.nemmco.Util.AuthorisationActionEnum;
import au.com.nemmco.Util.JsonUtilities;
import au.com.nemmco.Util.UpdateSet;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.WebContent;
import au.com.nemmco.Util.WebGET;
import au.com.nemmco.Util.WebPOST;
import au.com.nemmco.Util.WebPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/authentication/roles")
public class WebAPIAuthenticationRoles {
    private static Logger logger = LoggerFactory.getLogger(WebAPIAuthenticationRoles.class);

    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getRoles() {
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        String string = JsonUtilities.listToJson(authenticationManager.getRoles());
        return string;
    }

    @WebPOST(AdminAccessOnly=true, Action=AuthorisationActionEnum.WRITE)
    @WebContent(value=WebContent.MediaType.TEXT_PLAIN)
    public String createRole(String string) throws Exception {
        if (Util.isBlank(string)) {
            throw new Exception("Detected empty POST data");
        }
        Object object = null;
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        try {
            UpdateSet updateSet = JsonUtilities.fromJson(string, UpdateSet.class);
            authenticationManager.updateRoles(updateSet.Roles);
            object = "Successfully updated roles";
        }
        catch (Exception exception) {
            object = "Failed to update roles: " + exception.getMessage();
        }
        return object;
    }
}

