/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.AuthenticationManager;
import au.com.nemmco.Util.AuthorisationActionEnum;
import au.com.nemmco.Util.IdentityPrincipal;
import au.com.nemmco.Util.JsonUtilities;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.WebContent;
import au.com.nemmco.Util.WebGET;
import au.com.nemmco.Util.WebPOST;
import au.com.nemmco.Util.WebPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/authentication/users")
public class WebAPIAuthenticationUsers {
    private static Logger logger = LoggerFactory.getLogger(WebAPIAuthenticationUsers.class);

    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getUsers() {
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        String string = JsonUtilities.listToJson(authenticationManager.getUsers());
        return string;
    }

    @WebPOST(AdminAccessOnly=true, Action=AuthorisationActionEnum.WRITE)
    @WebContent(value=WebContent.MediaType.TEXT_PLAIN)
    public String createUser(String string) throws Exception {
        if (Util.isBlank(string)) {
            throw new Exception("Detected empty POST data");
        }
        Object object = null;
        AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
        try {
            IdentityPrincipal identityPrincipal = JsonUtilities.fromJson(string, IdentityPrincipal.class);
            authenticationManager.createUser(identityPrincipal);
            object = "Successfully saved user";
        }
        catch (Exception exception) {
            object = "Failed to save user: " + exception.getMessage();
        }
        return object;
    }
}

