/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.ApplicationManager;
import au.com.nemmco.Util.AuthorisationActionEnum;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.WebContent;
import au.com.nemmco.Util.WebGET;
import au.com.nemmco.Util.WebHandlerAPIWrapper;
import au.com.nemmco.Util.WebHandlerAPIWrapperMethod;
import au.com.nemmco.Util.WebPath;
import au.com.nemmco.Util.WebSecurityAuthenticationEnum;
import au.com.nemmco.Util.WebServer;
import java.util.List;

@WebPath(value="/api/webservices")
public class WebAPIServicesCatalog {
    private void addApplicationSummary(StringBuilder stringBuilder) {
        stringBuilder.append("<TABLE>");
        stringBuilder.append("<TR>");
        this.addData(stringBuilder, "Application:");
        this.addData(stringBuilder, ApplicationManager.getInstance().getApplication().getAppName());
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.addData(stringBuilder, "Version:");
        this.addData(stringBuilder, ApplicationManager.getInstance().getApplication().getAppVersion());
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    private void addHeader(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<TH>");
        stringBuilder.append(Util.noNull(string));
        stringBuilder.append("</TH>");
    }

    private void addData(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<TD>");
        stringBuilder.append(Util.noNull(string));
        stringBuilder.append("</TD>");
    }

    private void buildAPIDetail(StringBuilder stringBuilder, WebHandlerAPIWrapper webHandlerAPIWrapper, String string) {
        List<WebHandlerAPIWrapperMethod> list = webHandlerAPIWrapper.getMethods(string);
        if (list != null) {
            for (WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod : list) {
                stringBuilder.append("<TR>");
                this.addData(stringBuilder, webHandlerAPIWrapperMethod.path);
                this.addData(stringBuilder, string);
                if (webHandlerAPIWrapperMethod.ParamNames == null) {
                    this.addData(stringBuilder, null);
                } else if (webHandlerAPIWrapperMethod.ParamNames.size() == 0) {
                    this.addData(stringBuilder, null);
                } else {
                    this.addData(stringBuilder, String.join((CharSequence)",", webHandlerAPIWrapperMethod.ParamNames.toString()));
                }
                this.addData(stringBuilder, webHandlerAPIWrapperMethod.auth.name());
                this.addData(stringBuilder, webHandlerAPIWrapperMethod.AuthContext);
                this.addData(stringBuilder, webHandlerAPIWrapperMethod.action.name());
                this.addData(stringBuilder, webHandlerAPIWrapperMethod.contentType);
                this.addData(stringBuilder, Boolean.valueOf(webHandlerAPIWrapperMethod.AdminAccessOnly).toString());
                stringBuilder.append("</TR>");
            }
        }
    }

    @WebGET(Action=AuthorisationActionEnum.READ, Authentication=WebSecurityAuthenticationEnum.PUBLIC)
    @WebContent(value=WebContent.MediaType.TEXT_HTML)
    public String getStatus() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<HTML>");
        stringBuilder.append("<BODY>");
        stringBuilder.append("Web Service API summary");
        stringBuilder.append("<BR/>");
        stringBuilder.append("<BR/>");
        this.addApplicationSummary(stringBuilder);
        stringBuilder.append("<BR/>");
        stringBuilder.append("<TABLE>");
        stringBuilder.append("<TR>");
        this.addHeader(stringBuilder, "Path");
        this.addHeader(stringBuilder, "Method");
        this.addHeader(stringBuilder, "Parameters");
        this.addHeader(stringBuilder, "Authentication");
        this.addHeader(stringBuilder, "Auth Context");
        this.addHeader(stringBuilder, "Action");
        this.addHeader(stringBuilder, "Content Type");
        this.addHeader(stringBuilder, "Admin Access only");
        stringBuilder.append("</TR>");
        for (WebHandlerAPIWrapper webHandlerAPIWrapper : WebServer.getInstance().getHandlers()) {
            this.buildAPIDetail(stringBuilder, webHandlerAPIWrapper, "GET");
            this.buildAPIDetail(stringBuilder, webHandlerAPIWrapper, "POST");
        }
        stringBuilder.append("</TABLE>");
        stringBuilder.append("</BODY>");
        stringBuilder.append("</HTML>");
        return stringBuilder.toString();
    }
}

