/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.AuthenticationManager;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebContent;
import au.com.nemmco.Util.WebExecutionParams;
import au.com.nemmco.Util.WebHandlerAPIWrapper;
import au.com.nemmco.Util.WebHandlerAPIWrapperMethod;
import au.com.nemmco.Util.WebHandlerBase;
import au.com.nemmco.Util.WebHelper;
import au.com.nemmco.Util.WebSecurityAuthenticationEnum;
import au.com.nemmco.Util.WebServer;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHandlerAPI
extends WebHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(WebHandlerAPI.class);

    private WebAuth getWebAuth(HttpExchange httpExchange) {
        String[] stringArray;
        WebAuth webAuth = new WebAuth();
        String string = httpExchange.getRequestHeaders().getFirst("AUTHORIZATION");
        if (!Util.isBlank(string) && (stringArray = string.split(" ")) != null && stringArray.length == 2) {
            webAuth.AuthMethod = stringArray[0];
            webAuth.AuthDetail = stringArray[1];
        }
        return webAuth;
    }

    private WebRequest resolveRequest(HttpExchange httpExchange) {
        WebRequest webRequest = null;
        String string = httpExchange.getRequestMethod();
        String string2 = httpExchange.getRequestURI().getPath();
        String[] stringArray = string2.toString().split("/");
        Util_Logger.info(logger, "Received " + string + " request at " + string2 + " from " + httpExchange.getRemoteAddress().getHostString());
        WebServer webServer = WebServer.getInstance();
        for (WebHandlerAPIWrapper webHandlerAPIWrapper : webServer.itsHandlers.values()) {
            WebHandlerAPIWrapper webHandlerAPIWrapper2 = null;
            WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod = null;
            WebExecutionParams webExecutionParams = null;
            List<WebHandlerAPIWrapperMethod> list = webHandlerAPIWrapper.getMethods(string);
            if (list == null) continue;
            for (WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod2 : list) {
                WebExecutionParams webExecutionParams2 = webHandlerAPIWrapperMethod2.matches(stringArray);
                if (webExecutionParams2.Matches) {
                    webHandlerAPIWrapper2 = webHandlerAPIWrapper;
                    webHandlerAPIWrapperMethod = webHandlerAPIWrapperMethod2;
                    webExecutionParams = webExecutionParams2;
                }
                if (webHandlerAPIWrapper2 == null) continue;
                if (webRequest == null) {
                    webRequest = new WebRequest();
                    webRequest.exec = webHandlerAPIWrapperMethod2;
                    webRequest.wrapper = webHandlerAPIWrapper2;
                    webRequest.execParams = webExecutionParams;
                    continue;
                }
                if (webHandlerAPIWrapperMethod.URIParts.length > webRequest.exec.URIParts.length) {
                    webRequest.exec = webHandlerAPIWrapperMethod2;
                    webRequest.wrapper = webHandlerAPIWrapper2;
                    webRequest.execParams = webExecutionParams;
                    continue;
                }
                if (webHandlerAPIWrapperMethod.URIParts.length != webRequest.exec.URIParts.length || webHandlerAPIWrapperMethod.ParamNames.size() >= webRequest.exec.ParamNames.size()) continue;
                webRequest.exec = webHandlerAPIWrapperMethod2;
                webRequest.wrapper = webHandlerAPIWrapper2;
                webRequest.execParams = webExecutionParams;
            }
        }
        return webRequest;
    }

    private boolean validateRequest(HttpExchange httpExchange, String string, WebRequest webRequest) {
        boolean bl;
        block20: {
            bl = false;
            try {
                if (webRequest.exec.auth == WebSecurityAuthenticationEnum.PUBLIC) {
                    bl = true;
                    break block20;
                }
                WebAuth webAuth = this.getWebAuth(httpExchange);
                String string2 = WebServer.getInstance().getConfig().API_KEY;
                AuthenticationManager authenticationManager = AuthenticationManager.getInstance();
                if (!authenticationManager.isEnabled() && Util.isBlank(string2)) {
                    bl = true;
                    break block20;
                }
                if (Util.isBlank(webAuth.AuthDetail)) {
                    throw new Exception("Missing authentication detail in request header");
                }
                if (Util.isBlank(webAuth.AuthMethod)) {
                    throw new Exception("Missing authentication type in request header");
                }
                if (webAuth.AuthMethod.equalsIgnoreCase("BEARER")) {
                    bl = false;
                    if (authenticationManager.validateToken(webAuth.AuthDetail)) {
                        if (Util.isBlank(webRequest.exec.AuthContext)) {
                            bl = true;
                        } else {
                            String string3 = null;
                            if (!webRequest.exec.AdminAccessOnly) {
                                if (webRequest.execParams != null && webRequest.execParams.Params != null) {
                                    for (String string4 : webRequest.execParams.Params.keySet()) {
                                        if (!string4.equalsIgnoreCase(webRequest.exec.AuthContext)) continue;
                                        string3 = webRequest.execParams.Params.get(string4);
                                    }
                                }
                                if (Util.isBlank(string3)) {
                                    Util_Logger.errorNoRaise(logger, "Unable to identify secuity context parameter [" + webRequest.exec.AuthContext + "] from web handler " + webRequest.wrapper.Handler.toString());
                                    throw new Exception("Internal system error");
                                }
                            }
                            bl = authenticationManager.checkAuthorisation(webAuth.AuthDetail, httpExchange.getRequestURI().toString(), webRequest.exec.AdminAccessOnly, string3, webRequest.exec.action);
                        }
                    }
                    break block20;
                }
                if (webAuth.AuthMethod.equalsIgnoreCase("HMAC")) {
                    Date date;
                    long l2;
                    Mac mac = Mac.getInstance("HmacSHA256");
                    SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes(), "HmacSHA256");
                    mac.init(secretKeySpec);
                    long l3 = -1L;
                    String string5 = httpExchange.getRequestHeaders().getFirst("X-TIMESTAMP");
                    if (Util.isBlank(string5)) {
                        throw new Exception("Missing request header X-TIMESTAMP");
                    }
                    if (!Util.isInteger(string5)) {
                        throw new Exception("Invalid request header value for X-TIMESTAMP");
                    }
                    l3 = Long.parseLong(string5);
                    String string6 = webAuth.AuthDetail;
                    if (Util.isBlank(string5)) {
                        throw new Exception("Missing request header X-TIMESTAMP");
                    }
                    URL uRL = new URL("http://" + httpExchange.getRequestHeaders().getFirst("Host") + httpExchange.getRequestURI());
                    String string7 = WebHelper.signRequest(string2, uRL, string, l3);
                    if (!string6.equals(string7)) {
                        throw new Exception("Invalid request signature");
                    }
                    Integer n2 = WebServer.getInstance().getConfig().TimeDriftToleranceSeconds;
                    if (n2 != null && (l2 = Math.abs((l3 - (date = new Date()).getTime()) / 1000L)) > (long)n2.intValue()) {
                        throw new Exception("Invalid timestamp exceeds drift threshold of " + n2.toString() + " seconds");
                    }
                    bl = true;
                    break block20;
                }
                throw new Exception("Unknown authentication type [" + webAuth.AuthMethod + "] in request header");
            }
            catch (Exception exception) {
                bl = false;
                Util_Logger.warning(logger, "Error validating web request: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processRequest(HttpExchange httpExchange, String string) throws IOException {
        WebRequest webRequest = this.resolveRequest(httpExchange);
        String string2 = httpExchange.getRequestMethod();
        String string3 = httpExchange.getRequestURI().getPath();
        int n2 = 503;
        Object object = "Internal server error";
        String string4 = null;
        if (webRequest == null) {
            n2 = 404;
            string4 = WebContent.MediaType.TEXT_PLAIN.toString();
            object = "Invalid URL for " + string2 + " at " + string3;
            Util_Logger.errorNoRaise(logger, (String)object + " requested by " + httpExchange.getRemoteAddress().getHostString());
        } else {
            boolean bl = this.validateRequest(httpExchange, string, webRequest);
            if (!bl) {
                n2 = 403;
                string4 = WebContent.MediaType.TEXT_PLAIN.toString();
                object = "403 (Forbidden)";
            } else {
                try {
                    Object object2;
                    Object t2 = webRequest.wrapper.Handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (webRequest.wrapper.fieldURL != null) {
                        webRequest.wrapper.fieldURL.setAccessible(true);
                        webRequest.wrapper.fieldURL.set(t2, string3);
                    }
                    if (webRequest.wrapper.fieldParams != null) {
                        object2 = WebHelper.queryStringToMap(httpExchange.getRequestURI().getQuery());
                        webRequest.wrapper.fieldParams.setAccessible(true);
                        webRequest.wrapper.fieldParams.set(t2, object2);
                    }
                    if (webRequest.wrapper.fieldUUID != null) {
                        object2 = httpExchange.getRequestHeaders().getFirst("X-UUID");
                        webRequest.wrapper.fieldUUID.setAccessible(true);
                        webRequest.wrapper.fieldUUID.set(t2, object2);
                    }
                    if (webRequest.wrapper.fieldSessionKey != null) {
                        object2 = this.getWebAuth(httpExchange);
                        webRequest.wrapper.fieldSessionKey.setAccessible(true);
                        webRequest.wrapper.fieldSessionKey.set(t2, ((WebAuth)object2).AuthDetail);
                    }
                    string4 = webRequest.exec.contentType;
                    if (string2.equalsIgnoreCase("GET")) {
                        if (webRequest.getNoParams() == 0) {
                            object = (String)webRequest.exec.method.invoke(t2, new Object[0]);
                        } else if (webRequest.getNoParams() == 1) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0));
                        } else if (webRequest.getNoParams() == 2) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1));
                        } else if (webRequest.getNoParams() == 3) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2));
                        } else if (webRequest.getNoParams() == 4) {
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3));
                        } else {
                            if (webRequest.getNoParams() != 5) throw new Exception("Internal error, unable to invoke handler with > 5 arguments");
                            object = (String)webRequest.exec.method.invoke(t2, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3), webRequest.getParam(4));
                        }
                    } else if (webRequest.getNoParams() == 0) {
                        object = (String)webRequest.exec.method.invoke(t2, string);
                    } else if (webRequest.getNoParams() == 1) {
                        object = (String)webRequest.exec.method.invoke(t2, string, webRequest.getParam(0));
                    } else if (webRequest.getNoParams() == 2) {
                        object = (String)webRequest.exec.method.invoke(t2, string, webRequest.getParam(0), webRequest.getParam(1));
                    } else if (webRequest.getNoParams() == 3) {
                        object = (String)webRequest.exec.method.invoke(t2, string, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2));
                    } else if (webRequest.getNoParams() == 4) {
                        object = (String)webRequest.exec.method.invoke(t2, string, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3));
                    } else {
                        if (webRequest.getNoParams() != 5) throw new Exception("Internal error, unable to invoke handler with > 5 arguments");
                        object = (String)webRequest.exec.method.invoke(t2, string, webRequest.getParam(0), webRequest.getParam(1), webRequest.getParam(2), webRequest.getParam(3), webRequest.getParam(4));
                    }
                    n2 = 200;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Util_Logger.errorNoRaise(logger, "Error in Web Handler: " + invocationTargetException.getCause().getMessage(), new Exception(invocationTargetException.getCause()));
                    string4 = WebContent.MediaType.TEXT_PLAIN.toString();
                    String string5 = "Error processing request: ";
                    String string6 = invocationTargetException.getCause().getMessage();
                    object = string6.startsWith(string5) ? string6 : string5 + string6;
                }
                catch (Exception exception) {
                    Util_Logger.errorNoRaise(logger, "Error in Web Handler: " + exception.getMessage(), exception);
                    string4 = WebContent.MediaType.TEXT_PLAIN.toString();
                    object = "Internal server error: " + exception.getMessage();
                }
            }
        }
        try {
            Headers headers = httpExchange.getResponseHeaders();
            if (!Util.isBlank(string4)) {
                headers.add("Content-Type", string4.replace('_', '/'));
            }
            if (object == null) {
                object = "";
            }
            this.outputResponse(httpExchange, headers, n2, (String)object);
            return;
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error writing HTTP response: " + exception.getMessage(), exception);
        }
    }

    class WebAuth {
        public String AuthMethod;
        public String AuthDetail;

        WebAuth() {
        }
    }

    class WebRequest {
        public WebHandlerAPIWrapper wrapper = null;
        public WebExecutionParams execParams = null;
        public WebHandlerAPIWrapperMethod exec = null;

        WebRequest() {
        }

        public String getParam(int n2) {
            return this.execParams.Params.get(this.exec.ParamNames.get(n2));
        }

        public int getNoParams() {
            return this.exec.ParamNames.size();
        }
    }
}

