/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.IPUtilities;
import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebAccessEnum;
import au.com.nemmco.Util.WebServer;
import au.com.nemmco.Util.WebServerConfig;
import au.com.nemmco.Util.WebServerConfigIPAddress;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebHandlerBase
implements HttpHandler {
    private static Logger logger = LoggerFactory.getLogger(WebHandlerBase.class);

    public abstract void processRequest(HttpExchange var1, String var2) throws IOException;

    public String getSourceAddress(HttpExchange httpExchange) {
        return httpExchange.getRemoteAddress().getAddress().getHostAddress();
    }

    protected void outputResponse(HttpExchange httpExchange, Headers headers, int n2, String string) throws IOException {
        this.outputResponse(httpExchange, headers, n2, string.getBytes());
    }

    protected void outputResponse(HttpExchange httpExchange, Headers headers, int n2, byte[] byArray) throws IOException {
        Object object;
        WebServerConfig webServerConfig = WebServer.getInstance().getConfig();
        if (webServerConfig != null && !Util.isBlank(webServerConfig.ResponseHeaders) && (object = Util.getColumns(webServerConfig.ResponseHeaders, ';')) != null) {
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                Object object2 = object[i2];
                String[] stringArray = Util.getColumns((String)object2, ':');
                if (stringArray == null || stringArray.length != 2) continue;
                String string = stringArray[0];
                String string2 = stringArray[1];
                if (Util.isBlank(string) || Util.isBlank(string2)) continue;
                headers.add(string.trim(), string2.trim());
            }
        }
        httpExchange.sendResponseHeaders(n2, byArray.length);
        object = httpExchange.getResponseBody();
        try {
            ((OutputStream)object).write(byArray);
        }
        finally {
            if (object != null) {
                ((OutputStream)object).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readRequestBody(HttpExchange httpExchange) {
        String string = null;
        if (httpExchange.getRequestBody() != null) {
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                inputStreamReader = new InputStreamReader(httpExchange.getRequestBody());
                bufferedReader = new BufferedReader(inputStreamReader);
                string = bufferedReader.lines().collect(Collectors.joining(""));
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return string;
    }

    @Override
    public final void handle(HttpExchange httpExchange) throws IOException {
        String string = this.getSourceAddress(httpExchange);
        WebServerConfig webServerConfig = WebServer.getInstance().getConfig();
        boolean bl = true;
        if (webServerConfig.Hosts != null && webServerConfig.Hosts.size() > 0) {
            bl = false;
            for (WebServerConfigIPAddress object2 : webServerConfig.Hosts) {
                if (!IPUtilities.checkIPAddress(string, object2.Address)) continue;
                if (object2.Access == WebAccessEnum.ALLOW) {
                    bl = true;
                    continue;
                }
                if (object2.Access != WebAccessEnum.DENY) continue;
                bl = false;
            }
        }
        if (!bl) {
            Util_Logger.warning(logger, "Rejected web request from unauthorised host IP " + string);
        }
        Object object = null;
        if (bl) {
            object = this.readRequestBody(httpExchange);
            this.processRequest(httpExchange, (String)object);
        } else {
            Headers headers = httpExchange.getResponseHeaders();
            this.outputResponse(httpExchange, headers, 403, "403 (Forbidden)");
        }
    }
}

