/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Util;

import au.com.nemmco.Util.Util;
import au.com.nemmco.Util.Util_Logger;
import au.com.nemmco.Util.WebHandlerBase;
import au.com.nemmco.Util.WebServer;
import au.com.nemmco.Util.WebServerCache;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHandlerDocument
extends WebHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(WebHandlerDocument.class);

    @Override
    public void processRequest(HttpExchange httpExchange, String string) throws IOException {
        String string2 = WebServer.getInstance().getConfig().WWW_Root;
        URI uRI = httpExchange.getRequestURI();
        File file = new File(string2 + uRI.getPath()).getCanonicalFile();
        Headers headers = httpExchange.getResponseHeaders();
        if (Util.isBlank(string2)) {
            this.outputResponse(httpExchange, headers, 403, "403 (Forbidden)");
        } else if (!file.getPath().startsWith(string2)) {
            this.outputResponse(httpExchange, headers, 403, "403 (Forbidden)");
            Util_Logger.errorNoRaise(logger, "Detected suspected directory traversal attack, requested directory is " + file.getPath() + " from " + httpExchange.getRemoteAddress().getHostString());
        } else if (!file.isFile()) {
            this.outputResponse(httpExchange, headers, 404, "404 (Not Found)");
        } else {
            int n2;
            String string3 = file.getName().toLowerCase();
            if (string3.endsWith(".html")) {
                headers.add("Content-Type", "text/html");
            } else if (string3.endsWith(".css")) {
                headers.add("Content-Type", "text/css");
            } else if (string3.endsWith(".js")) {
                headers.add("Content-Type", "\u00e2\u20ac\u2039application/javascript");
            } else if (string3.endsWith(".svg")) {
                headers.add("Content-Type", "image/svg+xml");
            }
            byte[] byArray = null;
            try {
                WebServerCache webServerCache = WebServerCache.getInstance();
                byArray = webServerCache.getContent(file);
                n2 = 200;
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error reading content from server: " + exception.getMessage(), exception);
                byArray = new String("Error reading content from server").getBytes();
                n2 = 503;
            }
            this.outputResponse(httpExchange, headers, n2, byArray);
        }
    }
}

