/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class ASN1Boolean
extends ASN1Primitive {
    private static final byte[] a = new byte[]{-1};
    private static final byte[] b = new byte[]{0};
    private final byte[] c;
    public static final ASN1Boolean FALSE = new ASN1Boolean(false);
    public static final ASN1Boolean TRUE = new ASN1Boolean(true);

    public static ASN1Boolean getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Boolean) {
            return (ASN1Boolean)obj;
        }
        if (obj instanceof byte[]) {
            byte[] byArray = (byte[])obj;
            try {
                return (ASN1Boolean)ASN1Boolean.fromByteArray(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct boolean from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Boolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(int value) {
        return value != 0 ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof ASN1Boolean) {
            return ASN1Boolean.getInstance(aSN1Primitive);
        }
        return ASN1Boolean.a(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    ASN1Boolean(byte[] value) {
        if (value.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        this.c = value[0] == 0 ? b : ((value[0] & 0xFF) == 255 ? a : Arrays.clone(value));
    }

    public ASN1Boolean(boolean value) {
        this.c = value ? a : b;
    }

    public boolean isTrue() {
        return this.c[0] != 0;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 3;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(1, this.c);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o2) {
        if (o2 instanceof ASN1Boolean) {
            return this.c[0] == ((ASN1Boolean)o2).c[0];
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.c[0];
    }

    public String toString() {
        return this.c[0] != 0 ? "TRUE" : "FALSE";
    }

    static ASN1Boolean a(byte[] byArray) {
        if (byArray.length != 1) {
            throw new IllegalArgumentException("BOOLEAN value should have 1 byte in it");
        }
        if (byArray[0] == 0) {
            return FALSE;
        }
        if ((byArray[0] & 0xFF) == 255) {
            return TRUE;
        }
        return new ASN1Boolean(byArray);
    }
}

