/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Enumerated;
import com.enterprisedt.bouncycastle.asn1.ASN1Exception;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1StreamParser;
import com.enterprisedt.bouncycastle.asn1.ASN1UTCTime;
import com.enterprisedt.bouncycastle.asn1.BERApplicationSpecificParser;
import com.enterprisedt.bouncycastle.asn1.BEROctetString;
import com.enterprisedt.bouncycastle.asn1.BEROctetStringParser;
import com.enterprisedt.bouncycastle.asn1.BERSequenceParser;
import com.enterprisedt.bouncycastle.asn1.BERSetParser;
import com.enterprisedt.bouncycastle.asn1.BERTaggedObjectParser;
import com.enterprisedt.bouncycastle.asn1.BERTags;
import com.enterprisedt.bouncycastle.asn1.DERApplicationSpecific;
import com.enterprisedt.bouncycastle.asn1.DERBMPString;
import com.enterprisedt.bouncycastle.asn1.DERExternal;
import com.enterprisedt.bouncycastle.asn1.DERExternalParser;
import com.enterprisedt.bouncycastle.asn1.DERGeneralString;
import com.enterprisedt.bouncycastle.asn1.DERGraphicString;
import com.enterprisedt.bouncycastle.asn1.DERIA5String;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.DERNumericString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;
import com.enterprisedt.bouncycastle.asn1.DERT61String;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.DERUniversalString;
import com.enterprisedt.bouncycastle.asn1.DERVideotexString;
import com.enterprisedt.bouncycastle.asn1.DERVisibleString;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.asn1.d;
import com.enterprisedt.bouncycastle.asn1.e;
import com.enterprisedt.bouncycastle.asn1.g;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1InputStream
extends FilterInputStream
implements BERTags {
    private final int a;
    private final boolean b;
    private final byte[][] c;

    public ASN1InputStream(InputStream is) {
        this(is, i.a(is));
    }

    public ASN1InputStream(byte[] input) {
        this((InputStream)new ByteArrayInputStream(input), input.length);
    }

    public ASN1InputStream(byte[] input, boolean lazyEvaluate) {
        this(new ByteArrayInputStream(input), input.length, lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit) {
        this(input, limit, false);
    }

    public ASN1InputStream(InputStream input, boolean lazyEvaluate) {
        this(input, i.a(input), lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit, boolean lazyEvaluate) {
        super(input);
        this.a = limit;
        this.b = lazyEvaluate;
        this.c = new byte[11][];
    }

    int a() {
        return this.a;
    }

    protected int readLength() throws IOException {
        return ASN1InputStream.b(this, this.a);
    }

    protected void readFully(byte[] bytes) throws IOException {
        if (Streams.readFully(this, bytes) != bytes.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected ASN1Primitive buildObject(int tag, int tagNo, int length) throws IOException {
        boolean bl = (tag & 0x20) != 0;
        d d2 = new d(this, length);
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(bl, tagNo, d2.b());
        }
        if ((tag & 0x80) != 0) {
            return new ASN1StreamParser(d2).b(bl, tagNo);
        }
        if (bl) {
            switch (tagNo) {
                case 4: {
                    ASN1EncodableVector aSN1EncodableVector = this.a(d2);
                    ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[aSN1EncodableVector.size()];
                    for (int i2 = 0; i2 != aSN1OctetStringArray.length; ++i2) {
                        aSN1OctetStringArray[i2] = (ASN1OctetString)aSN1EncodableVector.get(i2);
                    }
                    return new BEROctetString(aSN1OctetStringArray);
                }
                case 16: {
                    if (this.b) {
                        return new g(d2.b());
                    }
                    return com.enterprisedt.bouncycastle.asn1.c.a(this.a(d2));
                }
                case 17: {
                    return com.enterprisedt.bouncycastle.asn1.c.b(this.a(d2));
                }
                case 8: {
                    return new DERExternal(this.a(d2));
                }
            }
            throw new IOException("unknown tag " + tagNo + " encountered");
        }
        return ASN1InputStream.a(tagNo, d2, this.c);
    }

    ASN1EncodableVector b() throws IOException {
        ASN1Primitive aSN1Primitive;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Primitive = this.readObject()) != null) {
            aSN1EncodableVector.add(aSN1Primitive);
        }
        return aSN1EncodableVector;
    }

    ASN1EncodableVector a(d d2) throws IOException {
        return new ASN1InputStream(d2).b();
    }

    public ASN1Primitive readObject() throws IOException {
        int n2 = this.read();
        if (n2 <= 0) {
            if (n2 == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int n3 = ASN1InputStream.a(this, n2);
        boolean bl = (n2 & 0x20) != 0;
        int n4 = this.readLength();
        if (n4 < 0) {
            if (!bl) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            e e2 = new e(this, this.a);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(e2, this.a);
            if ((n2 & 0x40) != 0) {
                return new BERApplicationSpecificParser(n3, aSN1StreamParser).getLoadedObject();
            }
            if ((n2 & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n3, aSN1StreamParser).getLoadedObject();
            }
            switch (n3) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getLoadedObject();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        try {
            return this.buildObject(n2, n3, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
        }
    }

    static int a(InputStream inputStream, int n2) throws IOException {
        int n3 = n2 & 0x1F;
        if (n3 == 31) {
            n3 = 0;
            int n4 = inputStream.read();
            if ((n4 & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (n4 >= 0 && (n4 & 0x80) != 0) {
                n3 |= n4 & 0x7F;
                n3 <<= 7;
                n4 = inputStream.read();
            }
            if (n4 < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            n3 |= n4 & 0x7F;
        }
        return n3;
    }

    static int b(InputStream inputStream, int n2) throws IOException {
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (n3 == 128) {
            return -1;
        }
        if (n3 > 127) {
            int n4 = n3 & 0x7F;
            if (n4 > 4) {
                throw new IOException("DER length more than 4 bytes: " + n4);
            }
            n3 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = inputStream.read();
                if (n5 < 0) {
                    throw new EOFException("EOF found reading length");
                }
                n3 = (n3 << 8) + n5;
            }
            if (n3 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n3 >= n2) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n3;
    }

    private static byte[] a(d d2, byte[][] byArray) throws IOException {
        int n2 = d2.a();
        if (d2.a() < byArray.length) {
            byte[] byArray2 = byArray[n2];
            if (byArray2 == null) {
                byArray[n2] = new byte[n2];
                byArray2 = byArray[n2];
            }
            Streams.readFully(d2, byArray2);
            return byArray2;
        }
        return d2.b();
    }

    private static char[] b(d d2) throws IOException {
        int n2;
        int n3;
        int n4 = d2.a() / 2;
        char[] cArray = new char[n4];
        int n5 = 0;
        while (n5 < n4 && (n3 = d2.read()) >= 0 && (n2 = d2.read()) >= 0) {
            cArray[n5++] = (char)(n3 << 8 | n2 & 0xFF);
        }
        return cArray;
    }

    static ASN1Primitive a(int n2, d d2, byte[][] byArray) throws IOException {
        switch (n2) {
            case 3: {
                return ASN1BitString.a(d2.a(), d2);
            }
            case 30: {
                return new DERBMPString(ASN1InputStream.b(d2));
            }
            case 1: {
                return ASN1Boolean.a(ASN1InputStream.a(d2, byArray));
            }
            case 10: {
                return ASN1Enumerated.a(ASN1InputStream.a(d2, byArray));
            }
            case 24: {
                return new ASN1GeneralizedTime(d2.b());
            }
            case 27: {
                return new DERGeneralString(d2.b());
            }
            case 22: {
                return new DERIA5String(d2.b());
            }
            case 2: {
                return new ASN1Integer(d2.b(), false);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(d2.b());
            }
            case 6: {
                return ASN1ObjectIdentifier.a(ASN1InputStream.a(d2, byArray));
            }
            case 4: {
                return new DEROctetString(d2.b());
            }
            case 19: {
                return new DERPrintableString(d2.b());
            }
            case 20: {
                return new DERT61String(d2.b());
            }
            case 28: {
                return new DERUniversalString(d2.b());
            }
            case 23: {
                return new ASN1UTCTime(d2.b());
            }
            case 12: {
                return new DERUTF8String(d2.b());
            }
            case 26: {
                return new DERVisibleString(d2.b());
            }
            case 25: {
                return new DERGraphicString(d2.b());
            }
            case 21: {
                return new DERVideotexString(d2.b());
            }
        }
        throw new IOException("unknown tag " + n2 + " encountered");
    }
}

