/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1SetParser;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERSet;
import com.enterprisedt.bouncycastle.asn1.BERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.DERSet;
import com.enterprisedt.bouncycastle.asn1.DLSet;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Iterable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class ASN1Set
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    private Vector a = new Vector();
    private boolean b = false;

    public static ASN1Set getInstance(Object obj) {
        ASN1Primitive aSN1Primitive;
        if (obj == null || obj instanceof ASN1Set) {
            return (ASN1Set)obj;
        }
        if (obj instanceof ASN1SetParser) {
            return ASN1Set.getInstance(((ASN1SetParser)obj).toASN1Primitive());
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1Set.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct set from byte[]: " + iOException.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1Set) {
            return (ASN1Set)aSN1Primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)obj.getObject();
        }
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (obj.isExplicit()) {
            if (obj instanceof BERTaggedObject) {
                return new BERSet(aSN1Primitive);
            }
            return new DLSet(aSN1Primitive);
        }
        if (aSN1Primitive instanceof ASN1Set) {
            return (ASN1Set)aSN1Primitive;
        }
        if (aSN1Primitive instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
            if (obj instanceof BERTaggedObject) {
                return new BERSet(aSN1Sequence.toArray());
            }
            return new DLSet(aSN1Sequence.toArray());
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    protected ASN1Set() {
    }

    protected ASN1Set(ASN1Encodable obj) {
        this.a.addElement(obj);
    }

    protected ASN1Set(ASN1EncodableVector v2, boolean doSort) {
        for (int i2 = 0; i2 != v2.size(); ++i2) {
            this.a.addElement(v2.get(i2));
        }
        if (doSort) {
            this.sort();
        }
    }

    protected ASN1Set(ASN1Encodable[] array, boolean doSort) {
        for (int i2 = 0; i2 != array.length; ++i2) {
            this.a.addElement(array[i2]);
        }
        if (doSort) {
            this.sort();
        }
    }

    public Enumeration getObjects() {
        return this.a.elements();
    }

    public ASN1Encodable getObjectAt(int index) {
        return (ASN1Encodable)this.a.elementAt(index);
    }

    public int size() {
        return this.a.size();
    }

    public ASN1Encodable[] toArray() {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[this.size()];
        for (int i2 = 0; i2 != this.size(); ++i2) {
            aSN1EncodableArray[i2] = this.getObjectAt(i2);
        }
        return aSN1EncodableArray;
    }

    public ASN1SetParser parser() {
        final ASN1Set aSN1Set = this;
        return new ASN1SetParser(){
            private final int c;
            private int d;
            {
                this.c = ASN1Set.this.size();
            }

            @Override
            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable aSN1Encodable;
                if (this.d == this.c) {
                    return null;
                }
                if ((aSN1Encodable = ASN1Set.this.getObjectAt(this.d++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)aSN1Encodable).parser();
                }
                if (aSN1Encodable instanceof ASN1Set) {
                    return ((ASN1Set)aSN1Encodable).parser();
                }
                return aSN1Encodable;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return aSN1Set;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return aSN1Set;
            }
        };
    }

    @Override
    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n2 = this.size();
        while (enumeration.hasMoreElements()) {
            ASN1Encodable aSN1Encodable = this.a(enumeration);
            n2 *= 17;
            n2 ^= aSN1Encodable.hashCode();
        }
        return n2;
    }

    @Override
    ASN1Primitive b() {
        if (this.b) {
            DERSet dERSet = new DERSet();
            ((ASN1Set)dERSet).a = this.a;
            return dERSet;
        }
        Vector vector = new Vector();
        for (int i2 = 0; i2 != this.a.size(); ++i2) {
            vector.addElement(this.a.elementAt(i2));
        }
        DERSet dERSet = new DERSet();
        ((ASN1Set)dERSet).a = vector;
        dERSet.sort();
        return dERSet;
    }

    @Override
    ASN1Primitive c() {
        DLSet dLSet = new DLSet();
        ((ASN1Set)dLSet).a = this.a;
        return dLSet;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof ASN1Set)) {
            return false;
        }
        ASN1Set aSN1Set = (ASN1Set)o2;
        if (this.size() != aSN1Set.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Primitive aSN1Primitive;
            ASN1Encodable aSN1Encodable = this.a(enumeration);
            ASN1Encodable aSN1Encodable2 = this.a(enumeration2);
            ASN1Primitive aSN1Primitive2 = aSN1Encodable.toASN1Primitive();
            if (aSN1Primitive2 == (aSN1Primitive = aSN1Encodable2.toASN1Primitive()) || aSN1Primitive2.equals(aSN1Primitive)) continue;
            return false;
        }
        return true;
    }

    private ASN1Encodable a(Enumeration enumeration) {
        ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        if (aSN1Encodable == null) {
            return DERNull.INSTANCE;
        }
        return aSN1Encodable;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        int n2 = Math.min(byArray.length, byArray2.length);
        for (int i2 = 0; i2 != n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return (byArray[i2] & 0xFF) < (byArray2[i2] & 0xFF);
        }
        return n2 == byArray.length;
    }

    private byte[] a(ASN1Encodable aSN1Encodable) {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
    }

    protected void sort() {
        if (!this.b) {
            this.b = true;
            if (this.a.size() > 1) {
                boolean bl = true;
                int n2 = this.a.size() - 1;
                while (bl) {
                    int n3 = 0;
                    byte[] byArray = this.a((ASN1Encodable)this.a.elementAt(0));
                    bl = false;
                    for (int i2 = 0; i2 != n2; ++i2) {
                        byte[] byArray2 = this.a((ASN1Encodable)this.a.elementAt(i2 + 1));
                        if (this.a(byArray, byArray2)) {
                            byArray = byArray2;
                            continue;
                        }
                        Object e2 = this.a.elementAt(i2);
                        this.a.setElementAt(this.a.elementAt(i2 + 1), i2);
                        this.a.setElementAt(e2, i2 + 1);
                        bl = true;
                        n3 = i2;
                    }
                    n2 = n3;
                }
            }
        }
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return this.a.toString();
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.toArray());
    }
}

