/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Exception;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObjectParser;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.DLTaggedObject;
import java.io.IOException;

public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    int a;
    boolean b = false;
    boolean c = true;
    ASN1Encodable d = null;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            return (ASN1TaggedObject)obj.getObject();
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public static ASN1TaggedObject getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1TaggedObject.getInstance(ASN1TaggedObject.fromByteArray((byte[])obj));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct tagged object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public ASN1TaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        this.c = obj instanceof ASN1Choice ? true : explicit;
        this.a = tagNo;
        if (this.c) {
            this.d = obj;
        } else {
            ASN1Primitive aSN1Primitive = obj.toASN1Primitive();
            if (aSN1Primitive instanceof ASN1Set) {
                Object var5_5 = null;
            }
            this.d = obj;
        }
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)o2;
        if (this.a != aSN1TaggedObject.a || this.b != aSN1TaggedObject.b || this.c != aSN1TaggedObject.c) {
            return false;
        }
        return !(this.d == null ? aSN1TaggedObject.d != null : !this.d.toASN1Primitive().equals(aSN1TaggedObject.d.toASN1Primitive()));
    }

    @Override
    public int hashCode() {
        int n2 = this.a;
        if (this.d != null) {
            n2 ^= this.d.hashCode();
        }
        return n2;
    }

    @Override
    public int getTagNo() {
        return this.a;
    }

    public boolean isExplicit() {
        return this.c;
    }

    public boolean isEmpty() {
        return this.b;
    }

    public ASN1Primitive getObject() {
        if (this.d != null) {
            return this.d.toASN1Primitive();
        }
        return null;
    }

    @Override
    public ASN1Encodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        switch (tag) {
            case 17: {
                return ASN1Set.getInstance(this, isExplicit).parser();
            }
            case 16: {
                return ASN1Sequence.getInstance(this, isExplicit).parser();
            }
            case 4: {
                return ASN1OctetString.getInstance(this, isExplicit).parser();
            }
        }
        if (isExplicit) {
            return this.getObject();
        }
        throw new ASN1Exception("implicit tagging not implemented for tag: " + tag);
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    ASN1Primitive b() {
        return new DERTaggedObject(this.c, this.a, this.d);
    }

    @Override
    ASN1Primitive c() {
        return new DLTaggedObject(this.c, this.a, this.d);
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return "[" + this.a + "]" + this.d;
    }
}

