/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public class DERNumericString
extends ASN1Primitive
implements ASN1String {
    private final byte[] a;

    public static DERNumericString getInstance(Object obj) {
        if (obj == null || obj instanceof DERNumericString) {
            return (DERNumericString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERNumericString)DERNumericString.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERNumericString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof DERNumericString) {
            return DERNumericString.getInstance(aSN1Primitive);
        }
        return new DERNumericString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    DERNumericString(byte[] string) {
        this.a = string;
    }

    public DERNumericString(String string) {
        this(string, false);
    }

    public DERNumericString(String string, boolean validate) {
        if (validate && !DERNumericString.isNumericString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.a = Strings.toByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.a);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.a);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.a.length) + this.a.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(18, this.a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERNumericString)) {
            return false;
        }
        DERNumericString dERNumericString = (DERNumericString)o2;
        return Arrays.areEqual(this.a, dERNumericString.a);
    }

    public static boolean isNumericString(String str) {
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            char c2 = str.charAt(i2);
            if (c2 > '\u007f') {
                return false;
            }
            if ('0' <= c2 && c2 <= '9' || c2 == ' ') continue;
            return false;
        }
        return true;
    }
}

