/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public class DERPrintableString
extends ASN1Primitive
implements ASN1String {
    private final byte[] a;

    public static DERPrintableString getInstance(Object obj) {
        if (obj == null || obj instanceof DERPrintableString) {
            return (DERPrintableString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERPrintableString)DERPrintableString.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERPrintableString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof DERPrintableString) {
            return DERPrintableString.getInstance(aSN1Primitive);
        }
        return new DERPrintableString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    DERPrintableString(byte[] string) {
        this.a = string;
    }

    public DERPrintableString(String string) {
        this(string, false);
    }

    public DERPrintableString(String string, boolean validate) {
        if (validate && !DERPrintableString.isPrintableString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.a = Strings.toByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.a);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.a);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.a.length) + this.a.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(19, this.a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERPrintableString)) {
            return false;
        }
        DERPrintableString dERPrintableString = (DERPrintableString)o2;
        return Arrays.areEqual(this.a, dERPrintableString.a);
    }

    public String toString() {
        return this.getString();
    }

    public static boolean isPrintableString(String str) {
        block3: for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            char c2 = str.charAt(i2);
            if (c2 > '\u007f') {
                return false;
            }
            if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9') continue;
            switch (c2) {
                case ' ': 
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': 
                case '?': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

