/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.i;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public class DERUTF8String
extends ASN1Primitive
implements ASN1String {
    private final byte[] a;

    public static DERUTF8String getInstance(Object obj) {
        if (obj == null || obj instanceof DERUTF8String) {
            return (DERUTF8String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERUTF8String)DERUTF8String.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof DERUTF8String) {
            return DERUTF8String.getInstance(aSN1Primitive);
        }
        return new DERUTF8String(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    DERUTF8String(byte[] string) {
        this.a = string;
    }

    public DERUTF8String(String string) {
        this.a = Strings.toUTF8ByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromUTF8ByteArray(this.a);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String dERUTF8String = (DERUTF8String)o2;
        return Arrays.areEqual(this.a, dERUTF8String.a);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() throws IOException {
        return 1 + i.a(this.a.length) + this.a.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.a(12, this.a);
    }
}

