/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.i;
import java.io.IOException;

public class DLBitString
extends ASN1BitString {
    public static ASN1BitString getInstance(Object obj) {
        if (obj == null || obj instanceof DLBitString) {
            return (DLBitString)obj;
        }
        if (obj instanceof DERBitString) {
            return (DERBitString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1BitString)DLBitString.fromByteArray((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1BitString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive aSN1Primitive = obj.getObject();
        if (explicit || aSN1Primitive instanceof DLBitString) {
            return DLBitString.getInstance(aSN1Primitive);
        }
        return DLBitString.a(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    protected DLBitString(byte data, int padBits) {
        this(DLBitString.a(data), padBits);
    }

    private static byte[] a(byte by) {
        byte[] byArray = new byte[]{by};
        return byArray;
    }

    public DLBitString(byte[] data, int padBits) {
        super(data, padBits);
    }

    public DLBitString(byte[] data) {
        this(data, 0);
    }

    public DLBitString(int value) {
        super(DLBitString.getBytes(value), DLBitString.getPadBits(value));
    }

    public DLBitString(ASN1Encodable obj) throws IOException {
        super(obj.toASN1Primitive().getEncoded("DER"), 0);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int a() {
        return 1 + i.a(this.data.length + 1) + this.data.length + 1;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        byte[] byArray = this.data;
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)this.getPadBits();
        System.arraycopy(byArray, 0, byArray2, 1, byArray2.length - 1);
        out.a(3, byArray2);
    }

    static DLBitString a(byte[] byArray) {
        if (byArray.length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        byte by = byArray[0];
        byte[] byArray2 = new byte[byArray.length - 1];
        if (byArray2.length != 0) {
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
        }
        return new DLBitString(byArray2, (int)by);
    }
}

