/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERGeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Date;

public class ObjectData
extends ASN1Object {
    private final BigInteger a;
    private final String b;
    private final ASN1GeneralizedTime c;
    private final ASN1GeneralizedTime d;
    private final ASN1OctetString e;
    private final String f;

    private ObjectData(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        this.b = DERUTF8String.getInstance(seq.getObjectAt(1)).getString();
        this.c = ASN1GeneralizedTime.getInstance(seq.getObjectAt(2));
        this.d = ASN1GeneralizedTime.getInstance(seq.getObjectAt(3));
        this.e = ASN1OctetString.getInstance(seq.getObjectAt(4));
        this.f = seq.size() == 6 ? DERUTF8String.getInstance(seq.getObjectAt(5)).getString() : null;
    }

    public ObjectData(BigInteger type, String identifier, Date creationDate, Date lastModifiedDate, byte[] data, String comment) {
        this.a = type;
        this.b = identifier;
        this.c = new DERGeneralizedTime(creationDate);
        this.d = new DERGeneralizedTime(lastModifiedDate);
        this.e = new DEROctetString(Arrays.clone(data));
        this.f = comment;
    }

    public static ObjectData getInstance(Object obj) {
        if (obj instanceof ObjectData) {
            return (ObjectData)obj;
        }
        if (obj != null) {
            return new ObjectData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public String getComment() {
        return this.f;
    }

    public ASN1GeneralizedTime getCreationDate() {
        return this.c;
    }

    public byte[] getData() {
        return Arrays.clone(this.e.getOctets());
    }

    public String getIdentifier() {
        return this.b;
    }

    public ASN1GeneralizedTime getLastModifiedDate() {
        return this.d;
    }

    public BigInteger getType() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new DERUTF8String(this.b));
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        if (this.f != null) {
            aSN1EncodableVector.add(new DERUTF8String(this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

