/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.bc.EncryptedObjectStoreData;
import com.enterprisedt.bouncycastle.asn1.bc.ObjectStoreData;
import com.enterprisedt.bouncycastle.asn1.bc.ObjectStoreIntegrityCheck;

public class ObjectStore
extends ASN1Object {
    private final ASN1Encodable a;
    private final ObjectStoreIntegrityCheck b;

    public ObjectStore(ObjectStoreData objectStoreData, ObjectStoreIntegrityCheck integrityCheck) {
        this.a = objectStoreData;
        this.b = integrityCheck;
    }

    public ObjectStore(EncryptedObjectStoreData encryptedObjectStoreData, ObjectStoreIntegrityCheck integrityCheck) {
        this.a = encryptedObjectStoreData;
        this.b = integrityCheck;
    }

    private ObjectStore(ASN1Sequence seq) {
        ASN1Sequence aSN1Sequence;
        if (seq.size() != 2) {
            throw new IllegalArgumentException("malformed sequence");
        }
        ASN1Encodable aSN1Encodable = seq.getObjectAt(0);
        this.a = aSN1Encodable instanceof EncryptedObjectStoreData ? aSN1Encodable : (aSN1Encodable instanceof ObjectStoreData ? aSN1Encodable : ((aSN1Sequence = ASN1Sequence.getInstance(aSN1Encodable)).size() == 2 ? EncryptedObjectStoreData.getInstance(aSN1Sequence) : ObjectStoreData.getInstance(aSN1Sequence)));
        this.b = ObjectStoreIntegrityCheck.getInstance(seq.getObjectAt(1));
    }

    public static ObjectStore getInstance(Object o2) {
        if (o2 instanceof ObjectStore) {
            return (ObjectStore)o2;
        }
        if (o2 != null) {
            return new ObjectStore(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ObjectStoreIntegrityCheck getIntegrityCheck() {
        return this.b;
    }

    public ASN1Encodable getStoreData() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

