/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERGeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.bc.ObjectDataSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;
import java.util.Date;

public class ObjectStoreData
extends ASN1Object {
    private final BigInteger a;
    private final AlgorithmIdentifier b;
    private final ASN1GeneralizedTime c;
    private final ASN1GeneralizedTime d;
    private final ObjectDataSequence e;
    private final String f;

    public ObjectStoreData(AlgorithmIdentifier integrityAlgorithm, Date creationDate, Date lastModifiedDate, ObjectDataSequence objectDataSequence, String comment) {
        this.a = BigInteger.valueOf(1L);
        this.b = integrityAlgorithm;
        this.c = new DERGeneralizedTime(creationDate);
        this.d = new DERGeneralizedTime(lastModifiedDate);
        this.e = objectDataSequence;
        this.f = comment;
    }

    private ObjectStoreData(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.c = ASN1GeneralizedTime.getInstance(seq.getObjectAt(2));
        this.d = ASN1GeneralizedTime.getInstance(seq.getObjectAt(3));
        this.e = ObjectDataSequence.getInstance(seq.getObjectAt(4));
        this.f = seq.size() == 6 ? DERUTF8String.getInstance(seq.getObjectAt(5)).getString() : null;
    }

    public static ObjectStoreData getInstance(Object o2) {
        if (o2 instanceof ObjectStoreData) {
            return (ObjectStoreData)o2;
        }
        if (o2 != null) {
            return new ObjectStoreData(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public String getComment() {
        return this.f;
    }

    public ASN1GeneralizedTime getCreationDate() {
        return this.c;
    }

    public AlgorithmIdentifier getIntegrityAlgorithm() {
        return this.b;
    }

    public ASN1GeneralizedTime getLastModifiedDate() {
        return this.d;
    }

    public ObjectDataSequence getObjectDataSequence() {
        return this.e;
    }

    public BigInteger getVersion() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        if (this.f != null) {
            aSN1EncodableVector.add(new DERUTF8String(this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

