/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartID;
import com.enterprisedt.bouncycastle.asn1.cmc.CMCStatus;
import com.enterprisedt.bouncycastle.asn1.cmc.OtherStatusInfo;
import com.enterprisedt.bouncycastle.asn1.cmc.a;

public class CMCStatusInfoV2
extends ASN1Object {
    private final CMCStatus a;
    private final ASN1Sequence b;
    private final DERUTF8String c;
    private final OtherStatusInfo d;

    CMCStatusInfoV2(CMCStatus cMCStatus, ASN1Sequence bodyList, DERUTF8String statusString, OtherStatusInfo otherStatusInfo) {
        this.a = cMCStatus;
        this.b = bodyList;
        this.c = statusString;
        this.d = otherStatusInfo;
    }

    private CMCStatusInfoV2(ASN1Sequence seq) {
        if (seq.size() < 2 || seq.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = CMCStatus.getInstance(seq.getObjectAt(0));
        this.b = ASN1Sequence.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            if (seq.size() == 4) {
                this.c = DERUTF8String.getInstance(seq.getObjectAt(2));
                this.d = OtherStatusInfo.getInstance(seq.getObjectAt(3));
            } else if (seq.getObjectAt(2) instanceof DERUTF8String) {
                this.c = DERUTF8String.getInstance(seq.getObjectAt(2));
                this.d = null;
            } else {
                this.c = null;
                this.d = OtherStatusInfo.getInstance(seq.getObjectAt(2));
            }
        } else {
            this.c = null;
            this.d = null;
        }
    }

    public CMCStatus getcMCStatus() {
        return this.a;
    }

    public BodyPartID[] getBodyList() {
        return com.enterprisedt.bouncycastle.asn1.cmc.a.a(this.b);
    }

    public DERUTF8String getStatusString() {
        return this.c;
    }

    public OtherStatusInfo getOtherStatusInfo() {
        return this.d;
    }

    public boolean hasOtherInfo() {
        return this.d != null;
    }

    public static CMCStatusInfoV2 getInstance(Object o2) {
        if (o2 instanceof CMCStatusInfoV2) {
            return (CMCStatusInfoV2)o2;
        }
        if (o2 != null) {
            return new CMCStatusInfoV2(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

