/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.util.Arrays;

public class IdentityProofV2
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final AlgorithmIdentifier b;
    private final byte[] c;

    public IdentityProofV2(AlgorithmIdentifier proofAlgID, AlgorithmIdentifier macAlgId, byte[] witness) {
        this.a = proofAlgID;
        this.b = macAlgId;
        this.c = Arrays.clone(witness);
    }

    private IdentityProofV2(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
    }

    public static IdentityProofV2 getInstance(Object o2) {
        if (o2 instanceof IdentityProofV2) {
            return (IdentityProofV2)o2;
        }
        if (o2 != null) {
            return new IdentityProofV2(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public AlgorithmIdentifier getProofAlgID() {
        return this.a;
    }

    public AlgorithmIdentifier getMacAlgId() {
        return this.b;
    }

    public byte[] getWitness() {
        return Arrays.clone(this.c);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new DEROctetString(this.getWitness()));
        return new DERSequence(aSN1EncodableVector);
    }
}

