/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmc.BodyPartID;

public class OtherMsg
extends ASN1Object {
    private final BodyPartID a;
    private final ASN1ObjectIdentifier b;
    private final ASN1Encodable c;

    public OtherMsg(BodyPartID bodyPartID, ASN1ObjectIdentifier otherMsgType, ASN1Encodable otherMsgValue) {
        this.a = bodyPartID;
        this.b = otherMsgType;
        this.c = otherMsgValue;
    }

    private OtherMsg(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartID.getInstance(seq.getObjectAt(0));
        this.b = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(1));
        this.c = seq.getObjectAt(2);
    }

    public static OtherMsg getInstance(Object o2) {
        if (o2 instanceof OtherMsg) {
            return (OtherMsg)o2;
        }
        if (o2 != null) {
            return new OtherMsg(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public static OtherMsg getInstance(ASN1TaggedObject obj, boolean explicit) {
        return OtherMsg.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    public BodyPartID getBodyPartID() {
        return this.a;
    }

    public ASN1ObjectIdentifier getOtherMsgType() {
        return this.b;
    }

    public ASN1Encodable getOtherMsgValue() {
        return this.c;
    }
}

