/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class PublishTrustAnchors
extends ASN1Object {
    private final ASN1Integer a;
    private final AlgorithmIdentifier b;
    private final ASN1Sequence c;

    public PublishTrustAnchors(BigInteger seqNumber, AlgorithmIdentifier hashAlgorithm, byte[][] anchorHashes) {
        this.a = new ASN1Integer(seqNumber);
        this.b = hashAlgorithm;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != anchorHashes.length; ++i2) {
            aSN1EncodableVector.add(new DEROctetString(Arrays.clone(anchorHashes[i2])));
        }
        this.c = new DERSequence(aSN1EncodableVector);
    }

    private PublishTrustAnchors(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.c = ASN1Sequence.getInstance(seq.getObjectAt(2));
    }

    public static PublishTrustAnchors getInstance(Object o2) {
        if (o2 instanceof PublishTrustAnchors) {
            return (PublishTrustAnchors)o2;
        }
        if (o2 != null) {
            return new PublishTrustAnchors(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public BigInteger getSeqNumber() {
        return this.a.getValue();
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.b;
    }

    public byte[][] getAnchorHashes() {
        byte[][] byArrayArray = new byte[this.c.size()][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone(ASN1OctetString.getInstance(this.c.getObjectAt(i2)).getOctets());
        }
        return byArrayArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

