/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmc;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmc.TaggedCertificationRequest;
import com.enterprisedt.bouncycastle.asn1.crmf.CertReqMsg;
import java.io.IOException;

public class TaggedRequest
extends ASN1Object
implements ASN1Choice {
    public static final int TCR = 0;
    public static final int CRM = 1;
    public static final int ORM = 2;
    private final int a;
    private final ASN1Encodable b;

    public TaggedRequest(TaggedCertificationRequest tcr) {
        this.a = 0;
        this.b = tcr;
    }

    public TaggedRequest(CertReqMsg crm) {
        this.a = 1;
        this.b = crm;
    }

    private TaggedRequest(ASN1Sequence orm) {
        this.a = 2;
        this.b = orm;
    }

    public static TaggedRequest getInstance(Object obj) {
        if (obj instanceof TaggedRequest) {
            return (TaggedRequest)obj;
        }
        if (obj != null) {
            if (obj instanceof ASN1Encodable) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(((ASN1Encodable)obj).toASN1Primitive());
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        return new TaggedRequest(TaggedCertificationRequest.getInstance(aSN1TaggedObject, false));
                    }
                    case 1: {
                        return new TaggedRequest(CertReqMsg.getInstance(aSN1TaggedObject, false));
                    }
                    case 2: {
                        return new TaggedRequest(ASN1Sequence.getInstance(aSN1TaggedObject, false));
                    }
                }
                throw new IllegalArgumentException("unknown tag in getInstance(): " + aSN1TaggedObject.getTagNo());
            }
            if (obj instanceof byte[]) {
                try {
                    return TaggedRequest.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("unknown encoding in getInstance()");
                }
            }
            throw new IllegalArgumentException("unknown object in getInstance(): " + obj.getClass().getName());
        }
        return null;
    }

    public int getTagNo() {
        return this.a;
    }

    public ASN1Encodable getValue() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.a, this.b);
    }
}

