/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmp.CertifiedKeyPair;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatusInfo;

public class CertResponse
extends ASN1Object {
    private ASN1Integer a;
    private PKIStatusInfo b;
    private CertifiedKeyPair c;
    private ASN1OctetString d;

    private CertResponse(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.b = PKIStatusInfo.getInstance(seq.getObjectAt(1));
        if (seq.size() >= 3) {
            if (seq.size() == 3) {
                ASN1Encodable aSN1Encodable = seq.getObjectAt(2);
                if (aSN1Encodable instanceof ASN1OctetString) {
                    this.d = ASN1OctetString.getInstance(aSN1Encodable);
                } else {
                    this.c = CertifiedKeyPair.getInstance(aSN1Encodable);
                }
            } else {
                this.c = CertifiedKeyPair.getInstance(seq.getObjectAt(2));
                this.d = ASN1OctetString.getInstance(seq.getObjectAt(3));
            }
        }
    }

    public static CertResponse getInstance(Object o2) {
        if (o2 instanceof CertResponse) {
            return (CertResponse)o2;
        }
        if (o2 != null) {
            return new CertResponse(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CertResponse(ASN1Integer certReqId, PKIStatusInfo status) {
        this(certReqId, status, null, null);
    }

    public CertResponse(ASN1Integer certReqId, PKIStatusInfo status, CertifiedKeyPair certifiedKeyPair, ASN1OctetString rspInfo) {
        if (certReqId == null) {
            throw new IllegalArgumentException("'certReqId' cannot be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("'status' cannot be null");
        }
        this.a = certReqId;
        this.b = status;
        this.c = certifiedKeyPair;
        this.d = rspInfo;
    }

    public ASN1Integer getCertReqId() {
        return this.a;
    }

    public PKIStatusInfo getStatus() {
        return this.b;
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

