/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatusInfo;
import java.math.BigInteger;

public class CertStatus
extends ASN1Object {
    private ASN1OctetString a;
    private ASN1Integer b;
    private PKIStatusInfo c;

    private CertStatus(ASN1Sequence seq) {
        this.a = ASN1OctetString.getInstance(seq.getObjectAt(0));
        this.b = ASN1Integer.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            this.c = PKIStatusInfo.getInstance(seq.getObjectAt(2));
        }
    }

    public CertStatus(byte[] certHash, BigInteger certReqId) {
        this.a = new DEROctetString(certHash);
        this.b = new ASN1Integer(certReqId);
    }

    public CertStatus(byte[] certHash, BigInteger certReqId, PKIStatusInfo statusInfo) {
        this.a = new DEROctetString(certHash);
        this.b = new ASN1Integer(certReqId);
        this.c = statusInfo;
    }

    public static CertStatus getInstance(Object o2) {
        if (o2 instanceof CertStatus) {
            return (CertStatus)o2;
        }
        if (o2 != null) {
            return new CertStatus(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ASN1OctetString getCertHash() {
        return this.a;
    }

    public ASN1Integer getCertReqId() {
        return this.b;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

