/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class Challenge
extends ASN1Object {
    private AlgorithmIdentifier a;
    private ASN1OctetString b;
    private ASN1OctetString c;

    private Challenge(ASN1Sequence seq) {
        int n2 = 0;
        if (seq.size() == 3) {
            this.a = AlgorithmIdentifier.getInstance(seq.getObjectAt(n2++));
        }
        this.b = ASN1OctetString.getInstance(seq.getObjectAt(n2++));
        this.c = ASN1OctetString.getInstance(seq.getObjectAt(n2));
    }

    public static Challenge getInstance(Object o2) {
        if (o2 instanceof Challenge) {
            return (Challenge)o2;
        }
        if (o2 != null) {
            return new Challenge(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public Challenge(byte[] witness, byte[] challenge) {
        this(null, witness, challenge);
    }

    public Challenge(AlgorithmIdentifier owf, byte[] witness, byte[] challenge) {
        this.a = owf;
        this.b = new DEROctetString(witness);
        this.c = new DEROctetString(challenge);
    }

    public AlgorithmIdentifier getOwf() {
        return this.a;
    }

    public byte[] getWitness() {
        return this.b.getOctets();
    }

    public byte[] getChallenge() {
        return this.c.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.a(aSN1EncodableVector, this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(aSN1Encodable);
        }
    }
}

