/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PBMParameter
extends ASN1Object {
    private ASN1OctetString a;
    private AlgorithmIdentifier b;
    private ASN1Integer c;
    private AlgorithmIdentifier d;

    private PBMParameter(ASN1Sequence seq) {
        this.a = ASN1OctetString.getInstance(seq.getObjectAt(0));
        this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.c = ASN1Integer.getInstance(seq.getObjectAt(2));
        this.d = AlgorithmIdentifier.getInstance(seq.getObjectAt(3));
    }

    public static PBMParameter getInstance(Object o2) {
        if (o2 instanceof PBMParameter) {
            return (PBMParameter)o2;
        }
        if (o2 != null) {
            return new PBMParameter(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PBMParameter(byte[] salt, AlgorithmIdentifier owf, int iterationCount, AlgorithmIdentifier mac) {
        this(new DEROctetString(salt), owf, new ASN1Integer(iterationCount), mac);
    }

    public PBMParameter(ASN1OctetString salt, AlgorithmIdentifier owf, ASN1Integer iterationCount, AlgorithmIdentifier mac) {
        this.a = salt;
        this.b = owf;
        this.c = iterationCount;
        this.d = mac;
    }

    public ASN1OctetString getSalt() {
        return this.a;
    }

    public AlgorithmIdentifier getOwf() {
        return this.b;
    }

    public ASN1Integer getIterationCount() {
        return this.c;
    }

    public AlgorithmIdentifier getMac() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }
}

