/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.InfoTypeAndValue;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIFreeText;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import java.util.Enumeration;

public class PKIHeader
extends ASN1Object {
    public static final GeneralName NULL_NAME = new GeneralName(X500Name.getInstance(new DERSequence()));
    public static final int CMP_1999 = 1;
    public static final int CMP_2000 = 2;
    private ASN1Integer a;
    private GeneralName b;
    private GeneralName c;
    private ASN1GeneralizedTime d;
    private AlgorithmIdentifier e;
    private ASN1OctetString f;
    private ASN1OctetString g;
    private ASN1OctetString h;
    private ASN1OctetString i;
    private ASN1OctetString j;
    private PKIFreeText k;
    private ASN1Sequence l;

    private PKIHeader(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        this.b = GeneralName.getInstance(enumeration.nextElement());
        this.c = GeneralName.getInstance(enumeration.nextElement());
        block11: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.d = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 1: {
                    this.e = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 2: {
                    this.f = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 3: {
                    this.g = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 4: {
                    this.h = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 5: {
                    this.i = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 6: {
                    this.j = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 7: {
                    this.k = PKIFreeText.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 8: {
                    this.l = ASN1Sequence.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public static PKIHeader getInstance(Object o2) {
        if (o2 instanceof PKIHeader) {
            return (PKIHeader)o2;
        }
        if (o2 != null) {
            return new PKIHeader(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PKIHeader(int pvno, GeneralName sender, GeneralName recipient) {
        this(new ASN1Integer(pvno), sender, recipient);
    }

    private PKIHeader(ASN1Integer pvno, GeneralName sender, GeneralName recipient) {
        this.a = pvno;
        this.b = sender;
        this.c = recipient;
    }

    public ASN1Integer getPvno() {
        return this.a;
    }

    public GeneralName getSender() {
        return this.b;
    }

    public GeneralName getRecipient() {
        return this.c;
    }

    public ASN1GeneralizedTime getMessageTime() {
        return this.d;
    }

    public AlgorithmIdentifier getProtectionAlg() {
        return this.e;
    }

    public ASN1OctetString getSenderKID() {
        return this.f;
    }

    public ASN1OctetString getRecipKID() {
        return this.g;
    }

    public ASN1OctetString getTransactionID() {
        return this.h;
    }

    public ASN1OctetString getSenderNonce() {
        return this.i;
    }

    public ASN1OctetString getRecipNonce() {
        return this.j;
    }

    public PKIFreeText getFreeText() {
        return this.k;
    }

    public InfoTypeAndValue[] getGeneralInfo() {
        if (this.l == null) {
            return null;
        }
        InfoTypeAndValue[] infoTypeAndValueArray = new InfoTypeAndValue[this.l.size()];
        for (int i2 = 0; i2 < infoTypeAndValueArray.length; ++i2) {
            infoTypeAndValueArray[i2] = InfoTypeAndValue.getInstance(this.l.getObjectAt(i2));
        }
        return infoTypeAndValueArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        this.a(aSN1EncodableVector, 0, this.d);
        this.a(aSN1EncodableVector, 1, this.e);
        this.a(aSN1EncodableVector, 2, this.f);
        this.a(aSN1EncodableVector, 3, this.g);
        this.a(aSN1EncodableVector, 4, this.h);
        this.a(aSN1EncodableVector, 5, this.i);
        this.a(aSN1EncodableVector, 6, this.j);
        this.a(aSN1EncodableVector, 7, this.k);
        this.a(aSN1EncodableVector, 8, this.l);
        return new DERSequence(aSN1EncodableVector);
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, n2, aSN1Encodable));
        }
    }
}

