/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIFailureInfo;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIFreeText;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatus;
import java.math.BigInteger;

public class PKIStatusInfo
extends ASN1Object {
    ASN1Integer a;
    PKIFreeText b;
    DERBitString c;

    public static PKIStatusInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIStatusInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static PKIStatusInfo getInstance(Object obj) {
        if (obj instanceof PKIStatusInfo) {
            return (PKIStatusInfo)obj;
        }
        if (obj != null) {
            return new PKIStatusInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PKIStatusInfo(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.b = null;
        this.c = null;
        if (seq.size() > 2) {
            this.b = PKIFreeText.getInstance(seq.getObjectAt(1));
            this.c = DERBitString.getInstance(seq.getObjectAt(2));
        } else if (seq.size() > 1) {
            ASN1Encodable aSN1Encodable = seq.getObjectAt(1);
            if (aSN1Encodable instanceof DERBitString) {
                this.c = DERBitString.getInstance(aSN1Encodable);
            } else {
                this.b = PKIFreeText.getInstance(aSN1Encodable);
            }
        }
    }

    public PKIStatusInfo(PKIStatus status) {
        this.a = ASN1Integer.getInstance(status.toASN1Primitive());
    }

    public PKIStatusInfo(PKIStatus status, PKIFreeText statusString) {
        this.a = ASN1Integer.getInstance(status.toASN1Primitive());
        this.b = statusString;
    }

    public PKIStatusInfo(PKIStatus status, PKIFreeText statusString, PKIFailureInfo failInfo) {
        this.a = ASN1Integer.getInstance(status.toASN1Primitive());
        this.b = statusString;
        this.c = failInfo;
    }

    public BigInteger getStatus() {
        return this.a.getValue();
    }

    public PKIFreeText getStatusString() {
        return this.b;
    }

    public DERBitString getFailInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

