/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIBody;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIHeader;

public class ProtectedPart
extends ASN1Object {
    private PKIHeader a;
    private PKIBody b;

    private ProtectedPart(ASN1Sequence seq) {
        this.a = PKIHeader.getInstance(seq.getObjectAt(0));
        this.b = PKIBody.getInstance(seq.getObjectAt(1));
    }

    public static ProtectedPart getInstance(Object o2) {
        if (o2 instanceof ProtectedPart) {
            return (ProtectedPart)o2;
        }
        if (o2 != null) {
            return new ProtectedPart(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ProtectedPart(PKIHeader header, PKIBody body) {
        this.a = header;
        this.b = body;
    }

    public PKIHeader getHeader() {
        return this.a;
    }

    public PKIBody getBody() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

