/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.enterprisedt.bouncycastle.asn1.cmp.RevRepContent;
import com.enterprisedt.bouncycastle.asn1.crmf.CertId;
import com.enterprisedt.bouncycastle.asn1.x509.CertificateList;

public class RevRepContentBuilder {
    private ASN1EncodableVector a = new ASN1EncodableVector();
    private ASN1EncodableVector b = new ASN1EncodableVector();
    private ASN1EncodableVector c = new ASN1EncodableVector();

    public RevRepContentBuilder add(PKIStatusInfo status) {
        this.a.add(status);
        return this;
    }

    public RevRepContentBuilder add(PKIStatusInfo status, CertId certId) {
        if (this.a.size() != this.b.size()) {
            throw new IllegalStateException("status and revCerts sequence must be in common order");
        }
        this.a.add(status);
        this.b.add(certId);
        return this;
    }

    public RevRepContentBuilder addCrl(CertificateList crl) {
        this.c.add(crl);
        return this;
    }

    public RevRepContent build() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERSequence(this.a));
        if (this.b.size() != 0) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, new DERSequence(this.b)));
        }
        if (this.c.size() != 0) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, new DERSequence(this.c)));
        }
        return RevRepContent.getInstance(new DERSequence(aSN1EncodableVector));
    }
}

