/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.ContentInfo;
import com.enterprisedt.bouncycastle.asn1.cms.OriginatorInfo;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class AuthenticatedData
extends ASN1Object {
    private ASN1Integer a;
    private OriginatorInfo b;
    private ASN1Set c;
    private AlgorithmIdentifier d;
    private AlgorithmIdentifier e;
    private ContentInfo f;
    private ASN1Set g;
    private ASN1OctetString h;
    private ASN1Set i;

    public AuthenticatedData(OriginatorInfo originatorInfo, ASN1Set recipientInfos, AlgorithmIdentifier macAlgorithm, AlgorithmIdentifier digestAlgorithm, ContentInfo encapsulatedContent, ASN1Set authAttrs, ASN1OctetString mac, ASN1Set unauthAttrs) {
        if (!(digestAlgorithm == null && authAttrs == null || digestAlgorithm != null && authAttrs != null)) {
            throw new IllegalArgumentException("digestAlgorithm and authAttrs must be set together");
        }
        this.a = new ASN1Integer(AuthenticatedData.calculateVersion(originatorInfo));
        this.b = originatorInfo;
        this.d = macAlgorithm;
        this.e = digestAlgorithm;
        this.c = recipientInfos;
        this.f = encapsulatedContent;
        this.g = authAttrs;
        this.h = mac;
        this.i = unauthAttrs;
    }

    private AuthenticatedData(ASN1Sequence seq) {
        int n2 = 0;
        this.a = (ASN1Integer)seq.getObjectAt(n2++);
        ASN1Encodable aSN1Encodable = seq.getObjectAt(n2++);
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            this.b = OriginatorInfo.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = seq.getObjectAt(n2++);
        }
        this.c = ASN1Set.getInstance(aSN1Encodable);
        this.d = AlgorithmIdentifier.getInstance(seq.getObjectAt(n2++));
        if ((aSN1Encodable = seq.getObjectAt(n2++)) instanceof ASN1TaggedObject) {
            this.e = AlgorithmIdentifier.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = seq.getObjectAt(n2++);
        }
        this.f = ContentInfo.getInstance(aSN1Encodable);
        if ((aSN1Encodable = seq.getObjectAt(n2++)) instanceof ASN1TaggedObject) {
            this.g = ASN1Set.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = seq.getObjectAt(n2++);
        }
        this.h = ASN1OctetString.getInstance(aSN1Encodable);
        if (seq.size() > n2) {
            this.i = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(n2), false);
        }
    }

    public static AuthenticatedData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return AuthenticatedData.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static AuthenticatedData getInstance(Object obj) {
        if (obj instanceof AuthenticatedData) {
            return (AuthenticatedData)obj;
        }
        if (obj != null) {
            return new AuthenticatedData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.b;
    }

    public ASN1Set getRecipientInfos() {
        return this.c;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.d;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.e;
    }

    public ContentInfo getEncapsulatedContentInfo() {
        return this.f;
    }

    public ASN1Set getAuthAttrs() {
        return this.g;
    }

    public ASN1OctetString getMac() {
        return this.h;
    }

    public ASN1Set getUnauthAttrs() {
        return this.i;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.b));
        }
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.e));
        }
        aSN1EncodableVector.add(this.f);
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.g));
        }
        aSN1EncodableVector.add(this.h);
        if (this.i != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, this.i));
        }
        return new BERSequence(aSN1EncodableVector);
    }

    public static int calculateVersion(OriginatorInfo origInfo) {
        ASN1TaggedObject aSN1TaggedObject;
        Object e2;
        if (origInfo == null) {
            return 0;
        }
        int n2 = 0;
        Enumeration enumeration = origInfo.getCertificates().getObjects();
        while (enumeration.hasMoreElements()) {
            e2 = enumeration.nextElement();
            if (!(e2 instanceof ASN1TaggedObject)) continue;
            aSN1TaggedObject = (ASN1TaggedObject)e2;
            if (aSN1TaggedObject.getTagNo() == 2) {
                n2 = 1;
                continue;
            }
            if (aSN1TaggedObject.getTagNo() != 3) continue;
            n2 = 3;
            break;
        }
        if (origInfo.getCRLs() != null) {
            enumeration = origInfo.getCRLs().getObjects();
            while (enumeration.hasMoreElements()) {
                e2 = enumeration.nextElement();
                if (!(e2 instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)e2).getTagNo() != 1) continue;
                n2 = 3;
                break;
            }
        }
        return n2;
    }
}

