/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;

public class GCMParameters
extends ASN1Object {
    private byte[] a;
    private int b;

    public static GCMParameters getInstance(Object obj) {
        if (obj instanceof GCMParameters) {
            return (GCMParameters)obj;
        }
        if (obj != null) {
            return new GCMParameters(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private GCMParameters(ASN1Sequence seq) {
        this.a = ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets();
        this.b = seq.size() == 2 ? ASN1Integer.getInstance(seq.getObjectAt(1)).getValue().intValue() : 12;
    }

    public GCMParameters(byte[] nonce, int icvLen) {
        this.a = Arrays.clone(nonce);
        this.b = icvLen;
    }

    public byte[] getNonce() {
        return Arrays.clone(this.a);
    }

    public int getIcvLen() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(this.a));
        if (this.b != 12) {
            aSN1EncodableVector.add(new ASN1Integer(this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

