/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cms.RecipientIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KeyTransRecipientInfo
extends ASN1Object {
    private ASN1Integer a;
    private RecipientIdentifier b;
    private AlgorithmIdentifier c;
    private ASN1OctetString d;

    public KeyTransRecipientInfo(RecipientIdentifier rid, AlgorithmIdentifier keyEncryptionAlgorithm, ASN1OctetString encryptedKey) {
        this.a = rid.toASN1Primitive() instanceof ASN1TaggedObject ? new ASN1Integer(2L) : new ASN1Integer(0L);
        this.b = rid;
        this.c = keyEncryptionAlgorithm;
        this.d = encryptedKey;
    }

    public KeyTransRecipientInfo(ASN1Sequence seq) {
        this.a = (ASN1Integer)seq.getObjectAt(0);
        this.b = RecipientIdentifier.getInstance(seq.getObjectAt(1));
        this.c = AlgorithmIdentifier.getInstance(seq.getObjectAt(2));
        this.d = (ASN1OctetString)seq.getObjectAt(3);
    }

    public static KeyTransRecipientInfo getInstance(Object obj) {
        if (obj instanceof KeyTransRecipientInfo) {
            return (KeyTransRecipientInfo)obj;
        }
        if (obj != null) {
            return new KeyTransRecipientInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public RecipientIdentifier getRecipientIdentifier() {
        return this.b;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.c;
    }

    public ASN1OctetString getEncryptedKey() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }
}

