/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERIA5String;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.cms.Attributes;

public class MetaData
extends ASN1Object {
    private ASN1Boolean a;
    private DERUTF8String b;
    private DERIA5String c;
    private Attributes d;

    public MetaData(ASN1Boolean hashProtected, DERUTF8String fileName, DERIA5String mediaType, Attributes otherMetaData) {
        this.a = hashProtected;
        this.b = fileName;
        this.c = mediaType;
        this.d = otherMetaData;
    }

    private MetaData(ASN1Sequence seq) {
        this.a = ASN1Boolean.getInstance(seq.getObjectAt(0));
        int n2 = 1;
        if (n2 < seq.size() && seq.getObjectAt(n2) instanceof DERUTF8String) {
            this.b = DERUTF8String.getInstance(seq.getObjectAt(n2++));
        }
        if (n2 < seq.size() && seq.getObjectAt(n2) instanceof DERIA5String) {
            this.c = DERIA5String.getInstance(seq.getObjectAt(n2++));
        }
        if (n2 < seq.size()) {
            this.d = Attributes.getInstance(seq.getObjectAt(n2++));
        }
    }

    public static MetaData getInstance(Object obj) {
        if (obj instanceof MetaData) {
            return (MetaData)obj;
        }
        if (obj != null) {
            return new MetaData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public boolean isHashProtected() {
        return this.a.isTrue();
    }

    public DERUTF8String getFileName() {
        return this.b;
    }

    public DERIA5String getMediaType() {
        return this.c;
    }

    public Attributes getOtherMetaData() {
        return this.d;
    }
}

