/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.enterprisedt.bouncycastle.asn1.cms.OriginatorPublicKey;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectKeyIdentifier;

public class OriginatorIdentifierOrKey
extends ASN1Object
implements ASN1Choice {
    private ASN1Encodable a;

    public OriginatorIdentifierOrKey(IssuerAndSerialNumber id) {
        this.a = id;
    }

    public OriginatorIdentifierOrKey(ASN1OctetString id) {
        this(new SubjectKeyIdentifier(id.getOctets()));
    }

    public OriginatorIdentifierOrKey(SubjectKeyIdentifier id) {
        this.a = new DERTaggedObject(false, 0, id);
    }

    public OriginatorIdentifierOrKey(OriginatorPublicKey id) {
        this.a = new DERTaggedObject(false, 1, id);
    }

    public OriginatorIdentifierOrKey(ASN1Primitive id) {
        this.a = id;
    }

    public static OriginatorIdentifierOrKey getInstance(ASN1TaggedObject o2, boolean explicit) {
        if (!explicit) {
            throw new IllegalArgumentException("Can't implicitly tag OriginatorIdentifierOrKey");
        }
        return OriginatorIdentifierOrKey.getInstance(o2.getObject());
    }

    public static OriginatorIdentifierOrKey getInstance(Object o2) {
        if (o2 == null || o2 instanceof OriginatorIdentifierOrKey) {
            return (OriginatorIdentifierOrKey)o2;
        }
        if (o2 instanceof IssuerAndSerialNumber || o2 instanceof ASN1Sequence) {
            return new OriginatorIdentifierOrKey(IssuerAndSerialNumber.getInstance(o2));
        }
        if (o2 instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)o2;
            if (aSN1TaggedObject.getTagNo() == 0) {
                return new OriginatorIdentifierOrKey(SubjectKeyIdentifier.getInstance(aSN1TaggedObject, false));
            }
            if (aSN1TaggedObject.getTagNo() == 1) {
                return new OriginatorIdentifierOrKey(OriginatorPublicKey.getInstance(aSN1TaggedObject, false));
            }
        }
        throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey: " + o2.getClass().getName());
    }

    public ASN1Encodable getId() {
        return this.a;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (this.a instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)this.a;
        }
        return null;
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        if (this.a instanceof ASN1TaggedObject && ((ASN1TaggedObject)this.a).getTagNo() == 0) {
            return SubjectKeyIdentifier.getInstance((ASN1TaggedObject)this.a, false);
        }
        return null;
    }

    public OriginatorPublicKey getOriginatorKey() {
        if (this.a instanceof ASN1TaggedObject && ((ASN1TaggedObject)this.a).getTagNo() == 1) {
            return OriginatorPublicKey.getInstance((ASN1TaggedObject)this.a, false);
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a.toASN1Primitive();
    }
}

