/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;

public class RsaKemParameters
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final BigInteger b;

    private RsaKemParameters(ASN1Sequence sequence) {
        if (sequence.size() != 2) {
            throw new IllegalArgumentException("ASN.1 SEQUENCE should be of length 2");
        }
        this.a = AlgorithmIdentifier.getInstance(sequence.getObjectAt(0));
        this.b = ASN1Integer.getInstance(sequence.getObjectAt(1)).getValue();
    }

    public static RsaKemParameters getInstance(Object o2) {
        if (o2 instanceof RsaKemParameters) {
            return (RsaKemParameters)o2;
        }
        if (o2 != null) {
            return new RsaKemParameters(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public RsaKemParameters(AlgorithmIdentifier keyDerivationFunction, int keyLength) {
        this.a = keyDerivationFunction;
        this.b = BigInteger.valueOf(keyLength);
    }

    public AlgorithmIdentifier getKeyDerivationFunction() {
        return this.a;
    }

    public BigInteger getKeyLength() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        return new DERSequence(aSN1EncodableVector);
    }
}

