/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.DERIA5String;
import com.enterprisedt.bouncycastle.asn1.cms.Evidence;
import com.enterprisedt.bouncycastle.asn1.cms.MetaData;

public class TimeStampedData
extends ASN1Object {
    private ASN1Integer a;
    private DERIA5String b;
    private MetaData c;
    private ASN1OctetString d;
    private Evidence e;

    public TimeStampedData(DERIA5String dataUri, MetaData metaData, ASN1OctetString content, Evidence temporalEvidence) {
        this.a = new ASN1Integer(1L);
        this.b = dataUri;
        this.c = metaData;
        this.d = content;
        this.e = temporalEvidence;
    }

    private TimeStampedData(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
        int n2 = 1;
        if (seq.getObjectAt(n2) instanceof DERIA5String) {
            this.b = DERIA5String.getInstance(seq.getObjectAt(n2++));
        }
        if (seq.getObjectAt(n2) instanceof MetaData || seq.getObjectAt(n2) instanceof ASN1Sequence) {
            this.c = MetaData.getInstance(seq.getObjectAt(n2++));
        }
        if (seq.getObjectAt(n2) instanceof ASN1OctetString) {
            this.d = ASN1OctetString.getInstance(seq.getObjectAt(n2++));
        }
        this.e = Evidence.getInstance(seq.getObjectAt(n2));
    }

    public static TimeStampedData getInstance(Object obj) {
        if (obj == null || obj instanceof TimeStampedData) {
            return (TimeStampedData)obj;
        }
        return new TimeStampedData(ASN1Sequence.getInstance(obj));
    }

    public DERIA5String getDataUri() {
        return this.b;
    }

    public MetaData getMetaData() {
        return this.c;
    }

    public ASN1OctetString getContent() {
        return this.d;
    }

    public Evidence getTemporalEvidence() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        aSN1EncodableVector.add(this.e);
        return new BERSequence(aSN1EncodableVector);
    }
}

